/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import j2html.TagCreator;
import j2html.tags.DomContent;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class StyleLintParser
extends JsonIssueParser {
    private static final long serialVersionUID = 761110211350972670L;

    @Override
    protected void parseJsonArray(Report report, JSONArray jsonReport, IssueBuilder issueBuilder) {
        for (Object issue : jsonReport) {
            if (!(issue instanceof JSONObject)) continue;
            JSONObject object = (JSONObject)issue;
            this.parseWarnings(report, object, issueBuilder);
        }
    }

    private void parseWarnings(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        issueBuilder.setFileName(jsonReport.getString("source"));
        JSONArray warnings = jsonReport.optJSONArray("warnings");
        for (Object issue : warnings) {
            if (!(issue instanceof JSONObject)) continue;
            JSONObject warning = (JSONObject)issue;
            report.add(this.convertToIssue(warning, issueBuilder));
        }
    }

    private Issue convertToIssue(JSONObject jsonIssue, IssueBuilder issueBuilder) {
        return issueBuilder.setType(jsonIssue.getString("rule")).setMessage(jsonIssue.getString("text")).setDescription(StyleLintParser.formatDescription(jsonIssue)).guessSeverity(jsonIssue.getString("severity")).setLineStart(jsonIssue.getInt("line")).setColumnStart(jsonIssue.getInt("column")).setLineEnd(jsonIssue.getInt("endLine")).setColumnEnd(jsonIssue.getInt("endColumn")).build();
    }

    private static String formatDescription(JSONObject jsonIssue) {
        String text;
        JSONObject fix = jsonIssue.optJSONObject("fix");
        if (fix != null && StringUtils.isNotBlank((CharSequence)(text = fix.getString("text")))) {
            return TagCreator.join((Object[])new Object[]{TagCreator.p((String)"Fix:"), TagCreator.pre().with((DomContent)TagCreator.code((String)text))}).render();
        }
        return "";
    }
}

