/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.DuplicationGroup;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.parser.AbstractDryParser;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.digester3.Digester;

public class SimianParser
extends AbstractDryParser<Set> {
    private static final long serialVersionUID = 6507147028628714706L;

    public SimianParser(int highThreshold, int normalThreshold) {
        super(highThreshold, normalThreshold);
    }

    public SimianParser() {
        super(50, 25);
    }

    @Override
    protected void configureParser(Digester digester) {
        String duplicationXPath = "*/simian/check/set";
        digester.addObjectCreate(duplicationXPath, Set.class);
        digester.addSetProperties(duplicationXPath);
        digester.addSetNext(duplicationXPath, "add");
        String fileXPath = duplicationXPath + "/block";
        digester.addObjectCreate(fileXPath, Block.class);
        digester.addSetProperties(fileXPath);
        digester.addSetNext(fileXPath, "addBlock", Block.class.getName());
    }

    @Override
    protected Report convertDuplicationsToIssues(List<Set> duplications, IssueBuilder issueBuilder) {
        Report report = new Report();
        for (Set duplication : duplications) {
            DuplicationGroup group = new DuplicationGroup();
            for (Block file : duplication.getBlocks()) {
                issueBuilder.setSeverity(this.getPriority(duplication.getLineCount())).setLineStart(file.getStartLineNumber()).setLineEnd(file.getEndLineNumber()).setFileName(file.getSourceFile()).setAdditionalProperties(group).setType("Simian");
                Issue issue = issueBuilder.build();
                group.add(issue);
                report.add(issue);
            }
        }
        return report;
    }

    public static class Set {
        private int lineCount;
        private final List<Block> blocks = new ArrayList<Block>();

        public void addBlock(Block block) {
            this.blocks.add(block);
        }

        public Collection<Block> getBlocks() {
            return Collections.unmodifiableCollection(this.blocks);
        }

        public int getLineCount() {
            return this.lineCount;
        }

        public void setLineCount(int value) {
            this.lineCount = value;
        }
    }

    public static class Block {
        @CheckForNull
        private String sourceFile;
        private int startLineNumber;
        private int endLineNumber;

        @CheckForNull
        public String getSourceFile() {
            return this.sourceFile;
        }

        public void setSourceFile(@CheckForNull String sourceFile) {
            this.sourceFile = sourceFile;
        }

        public int getStartLineNumber() {
            return this.startLineNumber;
        }

        public void setStartLineNumber(int startLineNumber) {
            this.startLineNumber = startLineNumber;
        }

        public int getEndLineNumber() {
            return this.endLineNumber;
        }

        public void setEndLineNumber(int endLineNumber) {
            this.endLineNumber = endLineNumber;
        }
    }
}

