/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.ArrayList;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;

public class PnpmAuditParser
extends JsonIssueParser {
    private static final String VALUE_NOT_SET = "-";
    private static final String UNCATEGORIZED = "Uncategorized";
    private static final String PNPM_VULNERABILITY_SEVERITY_INFO = "info";
    private static final String PNPM_VULNERABILITY_SEVERITY_LOW = "low";
    private static final String PNPM_VULNERABILITY_SEVERITY_MODERATE = "moderate";
    private static final String PNPM_VULNERABILITY_SEVERITY_HIGH = "high";
    private static final String PNPM_VULNERABILITY_SEVERITY_CRITICAL = "critical";
    private static final long serialVersionUID = 4140706319863200922L;

    @Override
    protected void parseJsonObject(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        JSONObject results = jsonReport.optJSONObject("advisories");
        if (results != null) {
            this.parseResults(report, results, issueBuilder);
        }
    }

    private void parseResults(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        for (String key : jsonReport.keySet()) {
            JSONObject vulnerability = (JSONObject)jsonReport.get(key);
            if (vulnerability.isEmpty()) continue;
            report.add(this.convertToIssue(vulnerability, issueBuilder));
        }
    }

    private Issue convertToIssue(JSONObject vulnerability, IssueBuilder issueBuilder) {
        return issueBuilder.setModuleName(vulnerability.optString("module_name", VALUE_NOT_SET)).setCategory(this.formatCategory(vulnerability)).setSeverity(this.mapSeverity(vulnerability.optString("severity", "UNKNOWN"))).setType(this.mapType(vulnerability)).setMessage(vulnerability.optString("overview", "UNKNOWN")).setDescription(this.formatDescription(vulnerability)).buildAndClean();
    }

    private String mapType(JSONObject vulnerability) {
        JSONArray cves = vulnerability.optJSONArray("cves");
        return cves != null && !cves.isNull(0) ? (String)cves.opt(0) : UNCATEGORIZED;
    }

    private String formatCategory(JSONObject vulnerability) {
        String moduleName = vulnerability.optString("module_name");
        String title = vulnerability.optString("title");
        if (moduleName != null && title != null) {
            return title.replace(moduleName, "").replace(" in ", "");
        }
        return VALUE_NOT_SET;
    }

    @SuppressFBWarnings(value={"IMPROPER_UNICODE"})
    private Severity mapSeverity(String string) {
        if (PNPM_VULNERABILITY_SEVERITY_INFO.equalsIgnoreCase(string)) {
            return Severity.WARNING_LOW;
        }
        if (PNPM_VULNERABILITY_SEVERITY_LOW.equalsIgnoreCase(string)) {
            return Severity.WARNING_LOW;
        }
        if (PNPM_VULNERABILITY_SEVERITY_MODERATE.equalsIgnoreCase(string)) {
            return Severity.WARNING_NORMAL;
        }
        if (PNPM_VULNERABILITY_SEVERITY_HIGH.equalsIgnoreCase(string)) {
            return Severity.WARNING_HIGH;
        }
        if (PNPM_VULNERABILITY_SEVERITY_CRITICAL.equalsIgnoreCase(string)) {
            return Severity.ERROR;
        }
        return Severity.WARNING_NORMAL;
    }

    private String formatDescription(JSONObject vulnerability) {
        ArrayList vulnerabilityTags = new ArrayList();
        this.getValueAsContainerTag(vulnerability, "module_name", "Module").ifPresent(vulnerabilityTags::add);
        JSONArray findings = vulnerability.optJSONArray("findings");
        if (findings != null && !findings.isEmpty()) {
            JSONObject firstFinding = (JSONObject)findings.opt(0);
            String installedVersion = firstFinding.optString("version");
            this.getValueAsContainerTag(installedVersion, "Installed Version").ifPresent(vulnerabilityTags::add);
        }
        this.getValueAsContainerTag(vulnerability, "vulnerable_versions", "Vulnerable Versions").ifPresent(vulnerabilityTags::add);
        this.getValueAsContainerTag(vulnerability, "patched_versions", "Patched Versions").ifPresent(vulnerabilityTags::add);
        this.getValueAsContainerTag(vulnerability, "severity", "Severity").ifPresent(vulnerabilityTags::add);
        this.getValueAsContainerTag(vulnerability, "overview").ifPresent(vulnerabilityTags::add);
        this.getValueAsContainerTag(vulnerability, "references", "References").ifPresent(vulnerabilityTags::add);
        return TagCreator.join((Object[])new Object[]{TagCreator.p((DomContent[])new DomContent[]{TagCreator.join((Object[])vulnerabilityTags.toArray())})}).render();
    }

    private Optional<ContainerTag> getValueAsContainerTag(JSONObject vulnerability, String tagOfValue) {
        String value = vulnerability.optString(tagOfValue);
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(TagCreator.p((DomContent[])new DomContent[]{TagCreator.text((String)value)}));
    }

    private Optional<ContainerTag> getValueAsContainerTag(String value, String label) {
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)(label + ": ")), TagCreator.text((String)value)}));
    }

    private Optional<ContainerTag> getValueAsContainerTag(JSONObject vulnerability, String tagOfValue, String label) {
        String value = vulnerability.optString(tagOfValue);
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)(label + ": ")), TagCreator.text((String)value)}));
    }
}

