/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.AbstractMavenLogParser;
import edu.hm.hafner.util.LookaheadStream;
import j2html.TagCreator;
import j2html.tags.DomContent;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

public class MavenConsoleParser
extends AbstractMavenLogParser {
    private static final long serialVersionUID = 1737791073711198075L;
    private static final String WARNING = "WARNING";
    private static final String ERROR = "ERROR";
    private static final String PATTERN = "^(?<timestamp>.*\\s|)\\[(?<severity>WARNING|ERROR)\\]\\s*(?<message>.*)$";

    public MavenConsoleParser() {
        super(PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return this.isValidGoal() && (line.contains(WARNING) || line.contains(ERROR));
    }

    private boolean isValidGoal() {
        return !this.hasGoals("maven-compiler-plugin", "maven-javadoc-plugin");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) throws ParsingException {
        String severity = matcher.group("severity");
        builder.setLineStart(lookahead.getLine()).guessSeverity(severity);
        StringBuilder message = new StringBuilder(matcher.group("message"));
        if (this.hasGoals("maven-enforcer-plugin")) {
            String timestamp = matcher.group("timestamp");
            int length = StringUtils.length((CharSequence)timestamp);
            String continuation = "^(?:.*\\s|)\\[(INFO|WARNING|ERROR)";
            while (lookahead.hasNext() && !lookahead.hasNext(continuation)) {
                message.append('\n');
                message.append(StringUtils.substring((String)lookahead.next(), (int)length));
            }
        } else {
            String continuation = "^(?:.*\\s\\s|)\\[" + severity + "\\] ";
            while (lookahead.hasNext(continuation)) {
                message.append('\n');
                message.append(RegExUtils.removeFirst((String)lookahead.next(), (String)continuation));
            }
            if (message.lastIndexOf("Unable to locate Source XRef to link to") >= 0) {
                builder.setSeverity(Severity.WARNING_LOW);
            }
            if (StringUtils.isBlank((CharSequence)message.toString())) {
                return Optional.empty();
            }
        }
        return builder.setDescription(TagCreator.pre().with((DomContent)TagCreator.code().withText(message.toString())).render()).setType(this.getGoal()).setModuleName(this.getModule()).setLineEnd(lookahead.getLine()).setFileName(lookahead.getFileName()).buildOptional();
    }
}

