/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.parser.JsonBaseParser;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonParser
extends JsonBaseParser {
    private static final long serialVersionUID = -6494117943149352139L;
    private static final String ISSUES = "issues";
    private static final boolean SEQUENTIAL = false;

    @Override
    public boolean accepts(ReaderFactory readerFactory) {
        return readerFactory.getFileName().endsWith(".json");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Report parseReport(ReaderFactory readerFactory) throws ParsingException {
        try (Reader reader = readerFactory.create();){
            IssueBuilder builder = new IssueBuilder();
            try {
                JSONObject jsonReport = (JSONObject)new JSONTokener(reader).nextValue();
                Report report = new Report();
                if (jsonReport.has(ISSUES)) {
                    JSONArray issues = jsonReport.getJSONArray(ISSUES);
                    StreamSupport.stream(issues.spliterator(), false).filter(JSONObject.class::isInstance).map(o -> this.convertToIssue((JSONObject)o, builder)).flatMap(Optional::stream).forEach(report::add);
                }
                Report report2 = report;
                builder.close();
                return report2;
            }
            catch (Throwable throwable) {
                try {
                    builder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | JSONException e) {
            throw new ParsingException(e);
        }
    }
}

