/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class GhsMultiParser
extends LookaheadParser {
    private static final long serialVersionUID = 8149238560432255036L;
    private static final String GHS_MULTI_WARNING_PATTERN = "\"(?<file>.*)\"\\,\\s*line\\s*(?<line>\\d+)(?:\\s+\\*?\\(col\\.\\s*(?<column>\\d+)\\)\\*?)?:\\s*(?<severity>warning|error)\\s*(?<category>[^:]+):\\s*(?m)(?<message>[^\\^]*)";
    private static final String MESSAGE_END_REGEX = "\\s*\\^";

    public GhsMultiParser() {
        super(GHS_MULTI_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String message;
        String type = StringUtils.capitalize((String)matcher.group("severity"));
        String messageStart = matcher.group("message");
        if (StringUtils.isNotBlank((CharSequence)matcher.group("column"))) {
            builder.setColumnStart(matcher.group("column"));
            message = messageStart;
        } else {
            message = this.extractMessage(messageStart, lookahead);
        }
        builder.setFileName(matcher.group("file")).setLineStart(matcher.group("line")).setCategory(matcher.group("category")).setMessage(message).setSeverity(Severity.guessFromString(type));
        return builder.buildOptional();
    }

    private String extractMessage(String messageStart, LookaheadStream lookahead) {
        StringBuilder messageBuilder = new StringBuilder(messageStart).append("\n");
        while (!lookahead.hasNext(MESSAGE_END_REGEX) && lookahead.hasNext()) {
            messageBuilder.append(lookahead.next()).append("\n");
        }
        return messageBuilder.toString();
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("warning") || line.contains("error");
    }
}

