/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.util.IntegerParser;
import edu.hm.hafner.util.LookaheadStream;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CargoClippyParser
extends LookaheadParser {
    private static final long serialVersionUID = -2677728927938443703L;
    private static final String CARGO_CLIPPY_REGEX_STRING = "^(?<level>.+):\\s+(?<summary>(?!.+generated [0-9]+ warning).+)";
    private static final Pattern CARGO_CLIPPY_FILE_PATTERN = Pattern.compile("^\\s+-->\\s(?<file>.+):(?<line>\\d+):(?<column>\\d+)");
    private static final Pattern CARGO_CLIPPY_REC_PATTERN = Pattern.compile("^(\\s+(\\d+\\s+)?)\\|(.+|\\n)");
    private static final Pattern CARGO_CLIPPY_NOTE_PATTERN = Pattern.compile("^\\s+=\\snote:\\s`#\\[(?<level>.+)\\((?<category>.+)\\)]`.+");
    private static final Pattern CARGO_CLIPPY_HELP_PATTERN = Pattern.compile("^\\s+=\\shelp:(.+?)(?<url>http?s:.*)?");
    private static final String CARGO_CLIPP_CONTEXT_CONTINUES = "^(\\s+|help\\:|[0-9]+).+";

    public CargoClippyParser() {
        super(CARGO_CLIPPY_REGEX_STRING);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        Severity defaultSeverity = Severity.guessFromString(matcher.group("level").trim());
        FileInformation description = this.createRecommendationMessage(lookahead);
        description.setLevel(matcher.group("level"));
        description.setSummary(matcher.group("summary"));
        builder.setFileName(description.getFile()).setLineStart(description.getLine()).setSeverity(defaultSeverity).setCategory(description.getCategory()).setColumnStart(description.getColumnStart()).setColumnEnd(description.getColumnEnd()).setDescription(description.getHelp()).setType(description.getLevel()).setMessage(description.getSummary());
        return builder.buildOptional();
    }

    private FileInformation createRecommendationMessage(LookaheadStream lookahead) {
        StringBuilder description = new StringBuilder();
        FileInformation fileInformation = new FileInformation();
        while (lookahead.hasNext(CARGO_CLIPP_CONTEXT_CONTINUES)) {
            String line = lookahead.next();
            Matcher fileInfoMatcher = CARGO_CLIPPY_FILE_PATTERN.matcher(line);
            if (fileInfoMatcher.matches()) {
                fileInformation.setFileName(fileInfoMatcher.group("file"));
                fileInformation.setFileLine(IntegerParser.parseInt(fileInfoMatcher.group("line")));
                fileInformation.setColumnStart(IntegerParser.parseInt(fileInfoMatcher.group("column")));
                continue;
            }
            Matcher clippyRecommendationMatcher = CARGO_CLIPPY_REC_PATTERN.matcher(line);
            if (clippyRecommendationMatcher.matches()) {
                description.append(line);
                continue;
            }
            Matcher clippyHelpMatcher = CARGO_CLIPPY_HELP_PATTERN.matcher(line);
            if (clippyHelpMatcher.matches()) {
                fileInformation.setHelp(clippyHelpMatcher.group(1), clippyHelpMatcher.group(2));
                continue;
            }
            Matcher clippyNotePatcher = CARGO_CLIPPY_NOTE_PATTERN.matcher(line);
            if (!clippyNotePatcher.matches()) continue;
            fileInformation.setCategory(clippyNotePatcher.group(2));
            fileInformation.setLevel(clippyNotePatcher.group(1));
        }
        if (description.toString().indexOf(94) != -1) {
            fileInformation.setColumnEnd(StringUtils.countMatches((CharSequence)description.toString(), (char)'^') + fileInformation.getColumnStart());
        }
        fileInformation.setRecommendation(description.toString());
        return fileInformation;
    }

    private static final class FileInformation {
        private String fileName = "";
        private Integer fileLine = 0;
        private String recommendation = "";
        private String category = "";
        private String level = "";
        private Integer columnStart = 0;
        private Integer columnEnd = 0;
        private String summary = "";
        private String help = "";

        FileInformation() {
        }

        @SuppressFBWarnings(value={"NM"})
        void setFileName(String fileName) {
            this.fileName = fileName;
        }

        String getFile() {
            return this.fileName;
        }

        void setFileLine(Integer fileLine) {
            this.fileLine = fileLine;
        }

        Integer getLine() {
            return this.fileLine;
        }

        void setRecommendation(String recommendation) {
            this.recommendation = recommendation;
        }

        String getRecommendation() {
            return this.recommendation;
        }

        void setCategory(String category) {
            this.category = category;
        }

        String getCategory() {
            return this.category;
        }

        void setLevel(String level) {
            this.level = level;
        }

        String getLevel() {
            return this.level;
        }

        void setColumnStart(Integer column) {
            this.columnStart = column;
        }

        Integer getColumnStart() {
            return this.columnStart;
        }

        void setColumnEnd(Integer column) {
            this.columnEnd = column;
        }

        Integer getColumnEnd() {
            return this.columnEnd;
        }

        void setSummary(String summary) {
            this.summary = summary;
        }

        String getSummary() {
            return this.summary;
        }

        void setHelp(String text, @CheckForNull String url) {
            this.help = StringUtils.isBlank((CharSequence)url) ? text : text + ((ContainerTag)TagCreator.a().withHref(url)).withText("cargo clippy documentation").render();
        }

        String getHelp() {
            return this.help;
        }
    }
}

