/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.Immutable;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.util.Ensure;
import edu.hm.hafner.util.Generated;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.Strings;

@Immutable
public class Severity
implements Serializable {
    private static final long serialVersionUID = 8921726169259131484L;
    public static final Severity ERROR = new Severity("ERROR");
    public static final Severity WARNING_HIGH = new Severity("HIGH");
    public static final Severity WARNING_NORMAL = new Severity("NORMAL");
    public static final Severity WARNING_LOW = new Severity("LOW");
    private static final Set<Severity> ALL_SEVERITIES = Collections.unmodifiableSet(new LinkedHashSet<Severity>(List.of(ERROR, WARNING_HIGH, WARNING_NORMAL, WARNING_LOW)));
    private final String name;

    public static Severity valueOf(String name) {
        if (ERROR.equalsIgnoreCase(name)) {
            return ERROR;
        }
        if (WARNING_HIGH.equalsIgnoreCase(name)) {
            return WARNING_HIGH;
        }
        if (WARNING_NORMAL.equalsIgnoreCase(name)) {
            return WARNING_NORMAL;
        }
        if (WARNING_LOW.equalsIgnoreCase(name)) {
            return WARNING_LOW;
        }
        return new Severity(name);
    }

    public static Severity valueOf(@CheckForNull String severity, Severity defaultValue) {
        if (severity == null || ALL_SEVERITIES.stream().map(Severity::getName).noneMatch(name -> name.equals(severity))) {
            return defaultValue;
        }
        return Severity.valueOf(severity);
    }

    public static Severity guessFromString(@CheckForNull String severity) {
        if (Strings.CI.containsAny((CharSequence)severity, new CharSequence[]{"error", "severe", "critical", "fatal"})) {
            return ERROR;
        }
        if (Strings.CI.containsAny((CharSequence)severity, new CharSequence[]{"info", "note", "low", "suggestion"})) {
            return WARNING_LOW;
        }
        if (Strings.CI.containsAny((CharSequence)severity, new CharSequence[]{"warning", "medium"})) {
            return WARNING_NORMAL;
        }
        if (Strings.CI.contains((CharSequence)severity, (CharSequence)"high")) {
            return WARNING_HIGH;
        }
        return WARNING_LOW;
    }

    public static Collection<Severity> collectSeveritiesFrom(Severity minimumSeverity) {
        ArrayList<Severity> priorities = new ArrayList<Severity>();
        priorities.add(ERROR);
        if (WARNING_HIGH.equals(minimumSeverity)) {
            priorities.add(WARNING_HIGH);
        } else if (WARNING_NORMAL.equals(minimumSeverity)) {
            priorities.add(WARNING_HIGH);
            priorities.add(WARNING_NORMAL);
        } else if (WARNING_LOW.equals(minimumSeverity)) {
            priorities.add(WARNING_HIGH);
            priorities.add(WARNING_NORMAL);
            priorities.add(WARNING_LOW);
        }
        return priorities;
    }

    public static Set<Severity> getPredefinedValues() {
        return ALL_SEVERITIES;
    }

    public Severity(String name) {
        Ensure.that((String)name).isNotBlank();
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equalsIgnoreCase(String severityName) {
        return IssueParser.equalsIgnoreCase(this.getName(), severityName);
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Severity severity = (Severity)o;
        return Objects.equals(this.name, severity.name);
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode(this.name);
    }
}

