/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sarif;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public class GUIDCalculator {
    public static UUID fromString(@NonNull String name) {
        return GUIDCalculator.calculateUUID5(null, name);
    }

    public static UUID fromNamespaceAndString(@NonNull UUID namespace, @NonNull String name) {
        return GUIDCalculator.calculateUUID5(namespace, name);
    }

    private static UUID calculateUUID5(UUID namespace, String name) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InternalError("The Hash Algorithm SHA-1 is not supported");
        }
        if (namespace != null) {
            messageDigest.update(GUIDCalculator.convertUUIDToBytes(namespace));
        }
        messageDigest.update(name.getBytes(StandardCharsets.UTF_8));
        byte[] digest = messageDigest.digest();
        digest[6] = (byte)(digest[6] & 0xF);
        digest[6] = (byte)(digest[6] | 0x50);
        digest[8] = (byte)(digest[8] & 0x3F);
        digest[8] = (byte)(digest[8] | 0x80);
        return GUIDCalculator.convertUUIDToBytes(digest);
    }

    private static UUID convertUUIDToBytes(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, 0, 16);
        long high = byteBuffer.getLong();
        long low = byteBuffer.getLong();
        return new UUID(high, low);
    }

    private static byte[] convertUUIDToBytes(UUID uuid) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        return buffer.array();
    }
}

