/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class FindNonShortCircuit
extends OpcodeStackDetector
implements StatelessDetector {
    static final String NS_NON_SHORT_CIRCUIT = "NS_NON_SHORT_CIRCUIT";
    static final String NS_DANGEROUS_NON_SHORT_CIRCUIT = "NS_DANGEROUS_NON_SHORT_CIRCUIT";
    int stage1 = 0;
    int stage2 = 0;
    int distance = 0;
    int operator;
    boolean sawDanger;
    boolean sawNullTestOld;
    boolean sawNullTestVeryOld;
    boolean sawNullTest;
    boolean sawDangerOld;
    boolean sawNumericTest;
    boolean sawNumericTestOld;
    boolean sawNumericTestVeryOld;
    boolean sawArrayDanger;
    boolean sawArrayDangerOld;
    boolean sawMethodCall;
    boolean sawMethodCallOld;
    private final BugAccumulator bugAccumulator;
    int prevOpcode;

    public FindNonShortCircuit(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(Method obj) {
        this.clearAll();
        this.prevOpcode = 0;
    }

    private void clearAll() {
        this.stage1 = 0;
        this.stage2 = 0;
        this.distance = 1000000;
        this.sawArrayDangerOld = false;
        this.sawArrayDanger = false;
        this.sawDangerOld = false;
        this.sawDanger = false;
        this.sawMethodCallOld = false;
        this.sawMethodCall = false;
        this.sawNullTestVeryOld = false;
        this.sawNullTestOld = false;
        this.sawNullTest = false;
        this.sawNumericTestVeryOld = false;
        this.sawNumericTestOld = false;
        this.sawNumericTest = false;
    }

    @Override
    public void visit(Code code) {
        super.visit(code);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        ++this.distance;
        this.scanForBooleanValue(seen);
        this.scanForDanger(seen);
        this.scanForShortCircuit(seen);
        this.prevOpcode = seen;
    }

    private void scanForDanger(int seen) {
        switch (seen) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.sawArrayDanger = true;
                this.sawDanger = true;
                break;
            }
            case 182: {
                if ("length".equals(this.getNameConstantOperand()) && "java/lang/String".equals(this.getClassConstantOperand())) break;
                this.sawDanger = true;
                this.sawMethodCall = true;
                break;
            }
            case 183: 
            case 184: 
            case 185: {
                this.sawDanger = true;
                this.sawMethodCall = true;
                break;
            }
            case 108: 
            case 109: 
            case 112: 
            case 113: {
                this.sawDanger = true;
                break;
            }
            case 180: 
            case 190: {
                break;
            }
        }
    }

    private void scanForShortCircuit(int seen) {
        switch (seen) {
            case 126: 
            case 128: {
                OpcodeStack.Item item0 = this.stack.getStackItem(0);
                OpcodeStack.Item item1 = this.stack.getStackItem(1);
                if (item0.getConstant() == null && item1.getConstant() == null && this.distance < 4) {
                    this.operator = seen;
                    this.stage2 = 1;
                    break;
                }
                this.stage2 = 0;
                break;
            }
            case 153: 
            case 154: {
                if (this.stage2 == 1) {
                    this.reportBug();
                }
                this.stage2 = 0;
                break;
            }
            case 172: 
            case 179: 
            case 181: {
                if (this.operator == 126 && this.stage2 == 1) {
                    this.reportBug();
                }
                this.stage2 = 0;
                break;
            }
            default: {
                this.stage2 = 0;
            }
        }
    }

    private void reportBug() {
        this.bugAccumulator.accumulateBug(this.createBugInstance().addClassAndMethod(this), this);
    }

    BugInstance createBugInstance() {
        int priority = 3;
        String pattern = NS_NON_SHORT_CIRCUIT;
        if (this.sawDangerOld) {
            if (this.sawNullTestVeryOld) {
                priority = 1;
            } else if (this.sawMethodCallOld || this.sawNumericTestVeryOld && this.sawArrayDangerOld) {
                priority = 1;
                pattern = NS_DANGEROUS_NON_SHORT_CIRCUIT;
            } else {
                priority = 2;
            }
        }
        return new BugInstance(this, pattern, priority);
    }

    private void scanForBooleanValue(int seen) {
        block0 : switch (seen) {
            case 126: 
            case 128: {
                switch (this.prevOpcode) {
                    case 21: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        this.clearAll();
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                this.stage1 = 1;
                switch (this.prevOpcode) {
                    case 198: 
                    case 199: {
                        this.sawNullTest = true;
                        break;
                    }
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: {
                        this.sawNumericTest = true;
                    }
                }
                break;
            }
            case 167: {
                if (this.stage1 == 1) {
                    this.stage1 = 2;
                    break;
                }
                this.stage1 = 0;
                this.clearAll();
                break;
            }
            case 3: {
                if (this.stage1 == 2) {
                    this.sawBooleanValue();
                }
                this.stage1 = 0;
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                String sig = this.getSigConstantOperand();
                if (sig.endsWith(")Z")) {
                    this.sawBooleanValue();
                }
                this.stage1 = 0;
                break;
            }
            default: {
                this.stage1 = 0;
            }
        }
    }

    private void sawBooleanValue() {
        this.sawMethodCallOld = this.sawMethodCall;
        this.sawDangerOld = this.sawDanger;
        this.sawArrayDangerOld = this.sawArrayDanger;
        this.sawNullTestVeryOld = this.sawNullTestOld;
        this.sawNullTestOld = this.sawNullTest;
        this.sawNumericTestVeryOld = this.sawNumericTestOld;
        this.sawNumericTestOld = this.sawNumericTest;
        this.sawNumericTest = false;
        this.sawDanger = false;
        this.sawArrayDanger = false;
        this.sawMethodCall = false;
        this.distance = 0;
        this.stage1 = 0;
    }
}

