/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseAction;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseActionType;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseEntry;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseEntryType;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.util.ExactStringMatcher;
import edu.umd.cs.findbugs.util.StringMatcher;
import edu.umd.cs.findbugs.util.SubtypeTypeMatcher;
import edu.umd.cs.findbugs.util.TypeMatcher;
import java.util.Arrays;
import java.util.Collection;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class MatchMethodEntry
implements ObligationPolicyDatabaseEntry {
    private final TypeMatcher receiverType;
    private final StringMatcher methodName;
    private final StringMatcher signature;
    private final boolean isStatic;
    private final ObligationPolicyDatabaseActionType action;
    private final Obligation[] obligations;
    private final ObligationPolicyDatabaseEntryType entryType;

    @Override
    public Collection<Obligation> getAllObligations() {
        return Arrays.asList(this.obligations);
    }

    public MatchMethodEntry(XMethod xmethod, ObligationPolicyDatabaseActionType action, ObligationPolicyDatabaseEntryType entryType, Obligation ... obligations) {
        this(new SubtypeTypeMatcher(xmethod.getClassDescriptor()), new ExactStringMatcher(xmethod.getName()), new ExactStringMatcher(xmethod.getSignature()), xmethod.isStatic(), action, entryType, obligations);
    }

    public MatchMethodEntry(MethodDescriptor method, ObligationPolicyDatabaseActionType action, ObligationPolicyDatabaseEntryType entryType, Obligation ... obligations) {
        this(new SubtypeTypeMatcher(method.getClassDescriptor()), new ExactStringMatcher(method.getName()), new ExactStringMatcher(method.getSignature()), method.isStatic(), action, entryType, obligations);
    }

    public MatchMethodEntry(TypeMatcher receiverType, StringMatcher methodName, StringMatcher signature, boolean isStatic, ObligationPolicyDatabaseActionType action, ObligationPolicyDatabaseEntryType entryType, Obligation ... obligations) {
        this.receiverType = receiverType;
        this.methodName = methodName;
        this.signature = signature;
        this.isStatic = isStatic;
        this.action = action;
        this.obligations = obligations;
        this.entryType = entryType;
    }

    @Override
    public ObligationPolicyDatabaseEntryType getEntryType() {
        return this.entryType;
    }

    @Override
    public boolean getActions(ReferenceType receiverType, String methodName, String signature, boolean isStatic, Collection<ObligationPolicyDatabaseAction> actionList) {
        if (this.methodName.matches(methodName) && this.signature.matches(signature) && this.isStatic == isStatic && this.receiverType.matches((Type)receiverType)) {
            for (Obligation o : this.obligations) {
                actionList.add(new ObligationPolicyDatabaseAction(this.action, o));
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "(" + String.valueOf(this.receiverType) + "," + String.valueOf(this.methodName) + "," + String.valueOf(this.signature) + "," + this.isStatic + "," + String.valueOf((Object)this.action) + "," + String.valueOf(Arrays.asList(this.obligations)) + "," + String.valueOf((Object)this.entryType) + ")";
    }
}

