/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.jsr305.FlowValue;
import edu.umd.cs.findbugs.ba.jsr305.ForwardTypeQualifierDataflow;
import edu.umd.cs.findbugs.ba.jsr305.ForwardTypeQualifierDataflowAnalysis;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierAnnotation;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierApplications;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierDatabase;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierDataflowFactory;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValueSet;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.Iterator;
import javax.annotation.meta.When;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.ReturnInstruction;

public class ForwardTypeQualifierDataflowFactory
extends TypeQualifierDataflowFactory<ForwardTypeQualifierDataflowAnalysis, ForwardTypeQualifierDataflow> {
    public ForwardTypeQualifierDataflowFactory(MethodDescriptor methodDescriptor) {
        super(methodDescriptor);
    }

    @Override
    protected ForwardTypeQualifierDataflow getDataflow(DepthFirstSearch dfs, XMethod xmethod, CFG cfg, ValueNumberDataflow vnaDataflow, ConstantPoolGen cpg, IAnalysisCache analysisCache, MethodDescriptor methodDescriptor, TypeQualifierValue<?> typeQualifierValue) throws DataflowAnalysisException {
        ForwardTypeQualifierDataflowAnalysis analysis = new ForwardTypeQualifierDataflowAnalysis(dfs, xmethod, cfg, vnaDataflow, cpg, typeQualifierValue);
        analysis.registerSourceSinkLocations();
        ForwardTypeQualifierDataflow dataflow = new ForwardTypeQualifierDataflow(cfg, analysis);
        dataflow.execute();
        if (ClassContext.DUMP_DATAFLOW_ANALYSIS) {
            dataflow.dumpDataflow(analysis);
        }
        return dataflow;
    }

    @Override
    protected void populateDatabase(ForwardTypeQualifierDataflow dataflow, ValueNumberDataflow vnaDataflow, XMethod xmethod, TypeQualifierValue<?> tqv) throws CheckedAnalysisException {
        assert (TypeQualifierDatabase.USE_DATABASE);
        if (xmethod.getSignature().endsWith(")V")) {
            return;
        }
        TypeQualifierAnnotation tqa = TypeQualifierApplications.getEffectiveTypeQualifierAnnotation(xmethod, tqv);
        if (tqa == null) {
            FlowValue effectiveFlowValue = null;
            CFG cfg = dataflow.getCFG();
            Iterator<Location> i = cfg.locationIterator();
            while (i.hasNext()) {
                Location loc = i.next();
                InstructionHandle handle = loc.getHandle();
                Instruction ins = handle.getInstruction();
                if (!(ins instanceof ReturnInstruction) || ins instanceof RETURN) continue;
                ValueNumberFrame vnaFrame = (ValueNumberFrame)vnaDataflow.getFactAtLocation(loc);
                ValueNumber topVN = (ValueNumber)vnaFrame.getTopValue();
                TypeQualifierValueSet flowSet = (TypeQualifierValueSet)dataflow.getFactAtLocation(loc);
                FlowValue topFlowValue = flowSet.getValue(topVN);
                if (topFlowValue == null) continue;
                if (TypeQualifierDatabase.DEBUG) {
                    System.out.println("at pc " + handle.getPosition() + " of " + String.valueOf(xmethod) + ", return value for " + String.valueOf(tqv) + " is " + String.valueOf((Object)topFlowValue));
                }
                if (effectiveFlowValue == null) {
                    effectiveFlowValue = topFlowValue;
                    continue;
                }
                effectiveFlowValue = FlowValue.meet(effectiveFlowValue, topFlowValue);
            }
            if (effectiveFlowValue == FlowValue.ALWAYS || effectiveFlowValue == FlowValue.NEVER) {
                TypeQualifierDatabase tqdb = Global.getAnalysisCache().getDatabase(TypeQualifierDatabase.class);
                if (TypeQualifierDatabase.DEBUG) {
                    System.out.println("inferring return value for " + String.valueOf(xmethod) + " of" + String.valueOf(tqv) + " : " + String.valueOf(effectiveFlowValue));
                }
                tqa = TypeQualifierAnnotation.getValue(tqv, effectiveFlowValue == FlowValue.ALWAYS ? When.ALWAYS : When.NEVER);
                tqdb.setReturnValue(xmethod.getMethodDescriptor(), tqv, tqa);
            }
        }
    }
}

