/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.bcp;

import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.bcp.BindingSet;
import edu.umd.cs.findbugs.ba.bcp.LocalVariable;
import edu.umd.cs.findbugs.ba.bcp.LongOrDoubleLocalVariable;
import edu.umd.cs.findbugs.ba.bcp.MatchResult;
import edu.umd.cs.findbugs.ba.bcp.SingleInstruction;
import edu.umd.cs.findbugs.ba.bcp.Variable;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Type;

public abstract class FieldAccess
extends SingleInstruction {
    private final String fieldVarName;
    private final String valueVarName;

    protected FieldAccess(String fieldVarName, String valueVarName) {
        this.fieldVarName = fieldVarName;
        this.valueVarName = valueVarName;
    }

    protected MatchResult checkConsistent(Variable field, Variable value, BindingSet bindingSet) {
        if ((bindingSet = FieldAccess.addOrCheckDefinition(this.fieldVarName, field, bindingSet)) == null) {
            return null;
        }
        if ((bindingSet = FieldAccess.addOrCheckDefinition(this.valueVarName, value, bindingSet)) == null) {
            return null;
        }
        return new MatchResult(this, bindingSet);
    }

    protected static boolean isLongOrDouble(FieldInstruction fieldIns, ConstantPoolGen cpg) {
        Type type = fieldIns.getFieldType(cpg);
        byte code = type.getType();
        return code == 11 || code == 7;
    }

    protected static Variable snarfFieldValue(FieldInstruction fieldIns, ConstantPoolGen cpg, ValueNumberFrame frame) throws DataflowAnalysisException {
        if (FieldAccess.isLongOrDouble(fieldIns, cpg)) {
            int numSlots = frame.getNumSlots();
            ValueNumber topValue = (ValueNumber)frame.getValue(numSlots - 1);
            ValueNumber nextValue = (ValueNumber)frame.getValue(numSlots - 2);
            return new LongOrDoubleLocalVariable(topValue, nextValue);
        }
        return new LocalVariable((ValueNumber)frame.getTopValue());
    }
}

