/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.asm;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.asm.FBClassReader;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import java.util.ArrayList;
import javax.annotation.CheckForNull;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public abstract class ClassNodeDetector
extends ClassNode
implements Detector2 {
    protected final BugReporter bugReporter;
    protected XClass xclass;

    protected ClassNodeDetector(BugReporter bugReporter) {
        super(589824);
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClass(ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        this.xclass = this.getClassInfo(classDescriptor);
        if (this.xclass != null) {
            FBClassReader cr = Global.getAnalysisCache().getClassAnalysis(FBClassReader.class, classDescriptor);
            this.interfaces = new ArrayList();
            this.innerClasses = new ArrayList();
            this.fields = new ArrayList();
            this.methods = new ArrayList();
            cr.accept((ClassVisitor)this, 0);
        }
    }

    @CheckForNull
    protected XClass getClassInfo(ClassDescriptor classDescr) {
        if (classDescr == null) {
            return null;
        }
        try {
            return Global.getAnalysisCache().getClassAnalysis(XClass.class, classDescr);
        }
        catch (CheckedAnalysisException e) {
            this.bugReporter.reportMissingClass(classDescr, e);
            return null;
        }
    }

    @Override
    public void finishPass() {
    }
}

