/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RecursiveFileSearch {
    private final String baseDir;
    private final FileFilter fileFilter;
    private final LinkedList<File> directoryWorkList;
    private final HashSet<String> directoriesScanned = new HashSet();
    private final List<String> directoriesScannedList = new LinkedList<String>();
    private final ArrayList<String> resultList;

    public RecursiveFileSearch(String baseDir, FileFilter fileFilter) {
        this.baseDir = baseDir;
        this.fileFilter = fileFilter;
        this.directoryWorkList = new LinkedList();
        this.resultList = new ArrayList();
    }

    static String bestEffortCanonicalPath(File f) {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            return f.getAbsolutePath();
        }
    }

    public RecursiveFileSearch search() throws InterruptedException {
        File baseFile = new File(this.baseDir);
        String basePath = RecursiveFileSearch.bestEffortCanonicalPath(baseFile);
        this.directoryWorkList.add(baseFile);
        this.directoriesScanned.add(basePath);
        this.directoriesScannedList.add(basePath);
        while (!this.directoryWorkList.isEmpty()) {
            File[] contentList;
            File dir = this.directoryWorkList.removeFirst();
            if (!dir.isDirectory() || (contentList = dir.listFiles()) == null) continue;
            for (File aContentList : contentList) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                File file = aContentList;
                if (!this.fileFilter.accept(file)) continue;
                if (file.isDirectory()) {
                    String myPath = RecursiveFileSearch.bestEffortCanonicalPath(file);
                    if (!myPath.startsWith(basePath) || !this.directoriesScanned.add(myPath)) continue;
                    this.directoriesScannedList.add(myPath);
                    this.directoryWorkList.add(file);
                    continue;
                }
                this.resultList.add(file.getPath());
            }
        }
        return this;
    }

    public Iterator<String> fileNameIterator() {
        return this.resultList.iterator();
    }

    public List<String> getDirectoriesScanned() {
        return Collections.unmodifiableList(this.directoriesScannedList);
    }
}

