/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class AnalysisError {
    private static final int PRIME = 31;
    private String message;
    private String exceptionMessage;
    private String[] stackTrace;
    private String nestedExceptionMessage;
    private String[] nestedStackTrace;
    private final Throwable exception;

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.exceptionMessage == null ? 0 : this.exceptionMessage.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.nestedExceptionMessage == null ? 0 : this.nestedExceptionMessage.hashCode());
        result = 31 * result + Arrays.hashCode(this.nestedStackTrace);
        result = 31 * result + Arrays.hashCode(this.stackTrace);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AnalysisError)) {
            return false;
        }
        AnalysisError other = (AnalysisError)obj;
        return Objects.equals(this.exceptionMessage, other.exceptionMessage) && Objects.equals(this.message, other.message) && Objects.equals(this.nestedExceptionMessage, other.nestedExceptionMessage) && Arrays.equals(this.nestedStackTrace, other.nestedStackTrace) && Arrays.equals(this.stackTrace, other.stackTrace);
    }

    public AnalysisError(String message) {
        this(message, null);
    }

    public AnalysisError(String message, Throwable exception) {
        this.message = message;
        this.exception = exception;
        if (exception != null) {
            this.exceptionMessage = exception.toString();
            this.stackTrace = this.getStackTraceAsStringArray(exception);
            Throwable initCause = exception.getCause();
            if (initCause != null) {
                this.nestedExceptionMessage = initCause.toString();
                this.nestedStackTrace = this.getStackTraceAsStringArray(initCause);
            }
        }
    }

    private String[] getStackTraceAsStringArray(Throwable exception) {
        StackTraceElement[] exceptionStackTrace = exception.getStackTrace();
        ArrayList<String> arr = new ArrayList<String>();
        for (StackTraceElement aExceptionStackTrace : exceptionStackTrace) {
            arr.add(aExceptionStackTrace.toString());
        }
        return arr.toArray(new String[0]);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getNestedExceptionMessage() {
        return this.nestedExceptionMessage;
    }

    public void setStackTrace(String[] stackTraceList) {
        this.stackTrace = stackTraceList;
    }

    public String[] getStackTrace() {
        return this.stackTrace;
    }

    public String[] getNestedStackTrace() {
        return this.nestedStackTrace;
    }

    public Throwable getException() {
        return this.exception;
    }
}

