/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.List;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JTypeVisitor;
import net.sourceforge.pmd.lang.java.types.JVariableSig;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;

public interface JClassType
extends JTypeMirror {
    @Override
    public @NonNull JClassSymbol getSymbol();

    @Override
    public JClassType withAnnotations(PSet<SymbolicValue.SymAnnot> var1);

    @Override
    default public JClassType subst(Function<? super SubstVar, ? extends @NonNull JTypeMirror> fun) {
        List<JTypeMirror> targs;
        if (Substitution.isEmptySubst(fun)) {
            return this;
        }
        JTypeMirror encl = this.getEnclosingType();
        if (encl != null) {
            encl = encl.subst((Function)fun);
        }
        if ((targs = this.getTypeArgs()).isEmpty() && encl == this.getEnclosingType()) {
            return this;
        }
        List<JTypeMirror> newArgs = TypeOps.subst(targs, fun);
        if (newArgs == targs && encl == this.getEnclosingType()) {
            return this;
        }
        return encl != null ? encl.selectInner(this.getSymbol(), newArgs, this.getTypeAnnotations()) : this.withTypeArguments(newArgs);
    }

    public boolean hasErasedSuperTypes();

    @Override
    public boolean isRaw();

    @Override
    public boolean isGenericTypeDeclaration();

    public JClassType getGenericTypeDeclaration();

    @Override
    public boolean isGeneric();

    public @Nullable JClassType getEnclosingType();

    public List<JTypeMirror> getTypeArgs();

    public List<JTypeVar> getFormalTypeParams();

    public Substitution getTypeParamSubst();

    default public JClassType selectInner(JClassSymbol symbol, List<? extends JTypeMirror> targs) {
        return this.selectInner(symbol, targs, (PSet<SymbolicValue.SymAnnot>)HashTreePSet.empty());
    }

    public JClassType selectInner(JClassSymbol var1, List<? extends JTypeMirror> var2, PSet<SymbolicValue.SymAnnot> var3);

    public @Nullable JClassType getSuperClass();

    @Override
    default public @Nullable JClassType getAsSuper(@NonNull JClassSymbol symbol) {
        return (JClassType)JTypeMirror.super.getAsSuper(symbol);
    }

    public @Nullable JMethodSig getDeclaredMethod(JExecutableSymbol var1);

    public List<JClassType> getDeclaredClasses();

    public List<JVariableSig.FieldSig> getDeclaredFields();

    public  @Nullable JVariableSig.FieldSig getDeclaredField(String var1);

    public @Nullable JClassType getDeclaredClass(String var1);

    @Override
    public JClassType getErasure();

    public List<JClassType> getSuperInterfaces();

    public JClassType withTypeArguments(List<? extends JTypeMirror> var1);

    @Override
    default public <T, P> T acceptVisitor(JTypeVisitor<T, P> visitor, P p) {
        return visitor.visitClass(this, p);
    }
}

