/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.GenericSigBase;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.SignatureScanner;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.TParamStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.TypeSigParser;
import net.sourceforge.pmd.lang.java.types.JTypeVar;

final class TypeParamsParser {
    private TypeParamsParser() {
    }

    static boolean hasTypeParams(String descriptor) {
        return descriptor.charAt(0) == '<';
    }

    static int typeParams(int start, BaseTypeParamsBuilder b) {
        int cur = b.consumeChar(start, '<', "type parameters");
        do {
            int idStart = cur;
            cur = TypeSigParser.identifier(cur, b, null);
            String tvarName = b.bufferToString(idStart, cur);
            int boundStart = cur;
            cur = TypeParamsParser.scanTypeBound(cur, b);
            b.addTypeParam(tvarName, b.bufferToString(boundStart, cur));
        } while (b.charAt(cur) != '>');
        cur = b.consumeChar(cur, '>');
        return cur;
    }

    private static int scanTypeBound(int start, SignatureScanner b) {
        int cur = b.consumeChar(start, ':', "class bound");
        char next = b.charAt(cur);
        if (next == '[' || next == 'L' || next == 'T') {
            cur = TypeParamsParser.skipReferenceType(cur, b);
        }
        while (b.charAt(cur) == ':') {
            cur = b.consumeChar(cur, ':');
            cur = TypeParamsParser.skipReferenceType(cur, b);
        }
        return cur;
    }

    static int skipReferenceType(int start, SignatureScanner b) {
        int cur = start;
        int targDepth = 0;
        block8: while (cur < b.end) {
            char c = b.charAt(cur);
            switch (c) {
                case 'T': {
                    cur = b.nextIndexOf(cur, ';');
                    continue block8;
                }
                case '.': 
                case 'L': {
                    cur = b.nextIndexOfAny(cur, ';', '<');
                    continue block8;
                }
                case '<': {
                    ++targDepth;
                    ++cur;
                    continue block8;
                }
                case '>': {
                    --targDepth;
                    ++cur;
                    continue block8;
                }
                case ';': {
                    if (targDepth == 0) {
                        return cur + 1;
                    }
                    ++cur;
                    continue block8;
                }
                case '*': 
                case '+': 
                case '-': 
                case '[': {
                    ++cur;
                    continue block8;
                }
            }
            throw b.expected("reference type part TL<;>[+-*.", cur);
        }
        return cur;
    }

    static class TypeParametersBuilder
    extends BaseTypeParamsBuilder {
        private final GenericSigBase<?> sig;
        private final List<JTypeVar> ownTypeParams = new ArrayList<JTypeVar>(1);

        TypeParametersBuilder(GenericSigBase<?> sig, String descriptor) {
            super(descriptor);
            this.sig = sig;
            assert (TypeParamsParser.hasTypeParams(descriptor)) : "No type parameters in this signature";
        }

        List<JTypeVar> getOwnerTypeParams() {
            return this.ownTypeParams;
        }

        @Override
        void addTypeParam(String id, String bound) {
            this.ownTypeParams.add(new TParamStub(id, this.sig, bound).getTypeMirror());
        }
    }

    static abstract class BaseTypeParamsBuilder
    extends SignatureScanner {
        BaseTypeParamsBuilder(String descriptor) {
            super(descriptor);
        }

        abstract void addTypeParam(String var1, String var2);
    }
}

