/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import org.apache.commons.lang3.NotImplementedException;

public final class ClassNamesUtil {
    private ClassNamesUtil() {
    }

    public static String getTypeDescriptor(Class<?> klass) {
        if (klass.isPrimitive()) {
            throw new NotImplementedException("Doesn't handle primitive types");
        }
        if (klass.isArray()) {
            return "[" + ClassNamesUtil.getTypeDescriptor(klass.getComponentType());
        }
        return "L" + ClassNamesUtil.getInternalName(klass) + ";";
    }

    public static String getInternalName(Class<?> klass) {
        return klass.getName().replace('.', '/');
    }

    public static String internalToBinaryName(String internal) {
        return internal.replace('/', '.');
    }

    public static String classDescriptorToBinaryName(String descriptor) {
        return ClassNamesUtil.internalToBinaryName(ClassNamesUtil.classDescriptorToInternalName(descriptor));
    }

    public static String classDescriptorToInternalName(String descriptor) {
        return descriptor.substring(1, descriptor.length() - 1);
    }

    public static String binaryToInternal(String binary) {
        return binary.replace('.', '/');
    }
}

