/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForInit;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTResource;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.InvocationMatcher;

public class PrematureDeclarationRule
extends AbstractJavaRulechainRule {
    private static final InvocationMatcher.CompoundInvocationMatcher TIME_METHODS = InvocationMatcher.parseAll("java.lang.System#nanoTime()", "java.lang.System#currentTimeMillis()");

    public PrematureDeclarationRule() {
        super(ASTLocalVariableDeclaration.class, new Class[0]);
    }

    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        if (node.getParent() instanceof ASTForInit || node.getParent() instanceof ASTResource) {
            return null;
        }
        block0: for (ASTVariableId id : node) {
            ASTStatement stmt;
            ASTExpression initializer = id.getInitializer();
            if (JavaAstUtils.isNeverUsed(id) || this.cannotBeMoved(initializer) || JavaRuleUtil.hasSideEffect(initializer, Collections.emptySet())) continue;
            Set<JVariableSymbol> refsInInitializer = PrematureDeclarationRule.getReferencedVars(initializer);
            boolean hasStatefulInitializer = !refsInInitializer.isEmpty() || JavaRuleUtil.hasSideEffect(initializer, Collections.emptySet());
            Iterator iterator = PrematureDeclarationRule.statementsAfter(node).iterator();
            while (!(!iterator.hasNext() || PrematureDeclarationRule.hasReferencesIn(stmt = (ASTStatement)iterator.next(), id) || hasStatefulInitializer && JavaRuleUtil.hasSideEffect(stmt, refsInInitializer))) {
                if (!PrematureDeclarationRule.hasExit(stmt)) continue;
                this.asCtx(data).addViolation((Node)node, new Object[]{id.getName()});
                continue block0;
            }
        }
        return null;
    }

    private static Set<JVariableSymbol> getReferencedVars(ASTExpression term) {
        return term == null ? Collections.emptySet() : (Set)term.descendantsOrSelf().filterIs(ASTAssignableExpr.ASTNamedReferenceExpr.class).filter(it -> it.getReferencedSym() != null).collect(Collectors.mapping(ASTAssignableExpr.ASTNamedReferenceExpr::getReferencedSym, Collectors.toSet()));
    }

    private boolean cannotBeMoved(ASTExpression initializer) {
        return TIME_METHODS.anyMatch(initializer);
    }

    private static boolean hasExit(ASTStatement block) {
        return block.descendants().map(NodeStream.asInstanceOf(ASTThrowStatement.class, (Class[])new Class[]{ASTReturnStatement.class})).nonEmpty();
    }

    private static boolean hasReferencesIn(ASTStatement stmt, ASTVariableId var) {
        return stmt.descendants(ASTVariableAccess.class).crossFindBoundaries().filterMatching(ASTAssignableExpr.ASTNamedReferenceExpr::getReferencedSym, (Object)((JVariableSymbol)var.getSymbol())).nonEmpty();
    }

    private static NodeStream<ASTStatement> statementsAfter(ASTLocalVariableDeclaration node) {
        return node.asStream().followingSiblings().filterIs(ASTStatement.class);
    }
}

