/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.renderers.AbstractRenderer;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;

public abstract class AbstractIncrementingRenderer
extends AbstractRenderer {
    protected List<Report.ProcessingError> errors = new LinkedList<Report.ProcessingError>();
    protected List<Report.ConfigurationError> configErrors = new LinkedList<Report.ConfigurationError>();
    protected List<Report.SuppressedViolation> suppressed = new LinkedList<Report.SuppressedViolation>();

    public AbstractIncrementingRenderer(String name, String description) {
        super(name, description);
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void startFileAnalysis(TextFile dataSource) {
    }

    @Override
    public void renderFileReport(Report report) throws IOException {
        Iterator<RuleViolation> violations = report.getViolations().iterator();
        if (violations.hasNext()) {
            this.renderFileViolations(violations);
            this.getWriter().flush();
        }
        this.errors.addAll(report.getProcessingErrors());
        this.configErrors.addAll(report.getConfigurationErrors());
        if (this.showSuppressedViolations) {
            this.suppressed.addAll(report.getSuppressedViolations());
        }
    }

    public abstract void renderFileViolations(Iterator<RuleViolation> var1) throws IOException;

    @Override
    public void end() throws IOException {
    }
}

