/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.sourceforge.pmd.properties.InternalApiBridge;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.PropertySerializer;
import net.sourceforge.pmd.properties.internal.PropertyParsingUtil;

public enum PropertyTypeId {
    BOOLEAN("Boolean", PropertyParsingUtil.BOOLEAN, PropertyFactory::booleanProperty),
    STRING("String", PropertyParsingUtil.STRING, PropertyFactory::stringProperty),
    STRING_LIST("List[String]", PropertyParsingUtil.STRING_LIST, PropertyFactory::stringListProperty),
    CHARACTER("Character", PropertyParsingUtil.CHARACTER, PropertyFactory::charProperty),
    CHARACTER_LIST("List[Character]", PropertyParsingUtil.CHAR_LIST, PropertyFactory::charListProperty),
    REGEX("Regex", PropertyParsingUtil.REGEX, PropertyFactory::regexProperty),
    INTEGER("Integer", PropertyParsingUtil.INTEGER, PropertyFactory::intProperty),
    INTEGER_LIST("List[Integer]", PropertyParsingUtil.INTEGER_LIST, PropertyFactory::intListProperty),
    LONG("Long", PropertyParsingUtil.LONG, PropertyFactory::longIntProperty),
    LONG_LIST("List[Long]", PropertyParsingUtil.LONG_LIST, PropertyFactory::longIntListProperty),
    DOUBLE("Double", PropertyParsingUtil.DOUBLE, PropertyFactory::doubleProperty),
    DOUBLE_LIST("List[Double]", PropertyParsingUtil.DOUBLE_LIST, PropertyFactory::doubleListProperty);

    private static final Map<String, PropertyTypeId> CONSTANTS_BY_MNEMONIC;
    private final String stringId;
    private final PropertySerializer<?> propertySerializer;
    private final Function<String, ? extends PropertyBuilder<?, ?>> factory;

    private <T> PropertyTypeId(String id, PropertySerializer<T> syntax, Function<String, PropertyBuilder<?, T>> factory) {
        this.stringId = id;
        this.propertySerializer = syntax;
        this.factory = factory;
    }

    public BuilderAndMapper<?> getBuilderUtils() {
        return new BuilderAndMapper(){

            public PropertySerializer<?> getXmlMapper() {
                return PropertyTypeId.this.propertySerializer;
            }

            public PropertyBuilder<?, ?> newBuilder(String name) {
                PropertyBuilder builder = (PropertyBuilder)PropertyTypeId.this.factory.apply(name);
                builder = InternalApiBridge.withTypeId(builder, PropertyTypeId.this);
                return builder.availableInXPath(true);
            }
        };
    }

    public String getStringId() {
        return this.stringId;
    }

    public static Map<String, PropertyTypeId> typeIdsToConstants() {
        return CONSTANTS_BY_MNEMONIC;
    }

    public static PropertyTypeId lookupMnemonic(String stringId) {
        return CONSTANTS_BY_MNEMONIC.get(stringId);
    }

    static {
        HashMap<String, PropertyTypeId> temp = new HashMap<String, PropertyTypeId>();
        for (PropertyTypeId id : PropertyTypeId.values()) {
            temp.put(id.stringId, id);
        }
        CONSTANTS_BY_MNEMONIC = Collections.unmodifiableMap(temp);
    }

    public static interface BuilderAndMapper<T> {
        public PropertySerializer<T> getXmlMapper();

        public PropertyBuilder<?, T> newBuilder(String var1);
    }
}

