/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;
import se.bjurr.violations.violationslib.com.google.gson.Gson;

public class ValgrindParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String reportContent, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(reportContent.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xml = ViolationParserUtils.createXmlReader(input);
            Gson gson = new Gson();
            String reporter = null;
            String source = null;
            String group = null;
            String tid = null;
            String threadName = null;
            String rule = null;
            String what = null;
            ArrayList<String> auxWhats = null;
            Element element = null;
            ArrayList stacks = null;
            ArrayList<StackFrame> stack = null;
            StackFrame frame = null;
            String suppression = null;
            while (xml.hasNext()) {
                int eventType = xml.next();
                if (eventType == 1) {
                    if (element == null && xml.getLocalName().equalsIgnoreCase("tool")) {
                        element = Element.TOOL;
                        continue;
                    }
                    if (element == null && xml.getLocalName().equalsIgnoreCase("args")) {
                        element = Element.ARGS;
                        continue;
                    }
                    if (element == Element.ARGS && xml.getLocalName().equalsIgnoreCase("argv")) {
                        element = Element.ARGV;
                        continue;
                    }
                    if (element == Element.ARGV && xml.getLocalName().equalsIgnoreCase("exe")) {
                        element = Element.EXE;
                        continue;
                    }
                    if (xml.getLocalName().equalsIgnoreCase("error")) {
                        element = Element.ERROR;
                        tid = null;
                        threadName = null;
                        group = null;
                        rule = null;
                        what = null;
                        auxWhats = new ArrayList<String>();
                        frame = null;
                        stack = null;
                        stacks = new ArrayList();
                        suppression = null;
                        continue;
                    }
                    if (element == Element.ERROR) {
                        if (xml.getLocalName().equalsIgnoreCase("unique")) {
                            element = Element.UNIQUE;
                            continue;
                        }
                        if (xml.getLocalName().equalsIgnoreCase("tid")) {
                            element = Element.TID;
                            continue;
                        }
                        if (xml.getLocalName().equalsIgnoreCase("threadname")) {
                            element = Element.THREADNAME;
                            continue;
                        }
                        if (xml.getLocalName().equalsIgnoreCase("kind")) {
                            element = Element.KIND;
                            continue;
                        }
                        if (xml.getLocalName().equalsIgnoreCase("what")) {
                            element = Element.WHAT;
                            continue;
                        }
                        if (xml.getLocalName().equalsIgnoreCase("auxwhat")) {
                            element = Element.AUXWHAT;
                            continue;
                        }
                        if (xml.getLocalName().equalsIgnoreCase("xwhat")) {
                            element = Element.XWHAT;
                            continue;
                        }
                        if (xml.getLocalName().equalsIgnoreCase("xauxwhat")) {
                            element = Element.XAUXWHAT;
                            continue;
                        }
                        if (xml.getLocalName().equalsIgnoreCase("stack")) {
                            element = Element.STACK;
                            stack = new ArrayList<StackFrame>();
                            continue;
                        }
                        if (!xml.getLocalName().equalsIgnoreCase("suppression")) continue;
                        element = Element.SUPPRESSION;
                        continue;
                    }
                    if (element == Element.STACK && xml.getLocalName().equalsIgnoreCase("frame")) {
                        frame = new StackFrame();
                        element = Element.FRAME;
                        continue;
                    }
                    if (element == Element.FRAME) {
                        if (xml.getLocalName().equalsIgnoreCase("ip")) {
                            element = Element.IP;
                            continue;
                        }
                        if (xml.getLocalName().equalsIgnoreCase("obj")) {
                            element = Element.OBJ;
                            continue;
                        }
                        if (xml.getLocalName().equalsIgnoreCase("fn")) {
                            element = Element.FN;
                            continue;
                        }
                        if (xml.getLocalName().equalsIgnoreCase("dir")) {
                            element = Element.DIR;
                            continue;
                        }
                        if (xml.getLocalName().equalsIgnoreCase("file")) {
                            element = Element.FILE;
                            continue;
                        }
                        if (!xml.getLocalName().equalsIgnoreCase("line")) continue;
                        element = Element.LINE;
                        continue;
                    }
                    if (xml.getLocalName().equalsIgnoreCase("text")) {
                        if (element == Element.XWHAT) {
                            element = Element.XWHAT_TEXT;
                            continue;
                        }
                        if (element != Element.XAUXWHAT) continue;
                        element = Element.XAUXWHAT_TEXT;
                        continue;
                    }
                    if (element != Element.SUPPRESSION || !xml.getLocalName().equalsIgnoreCase("rawtext")) continue;
                    element = Element.SUPPRESSION_RAWTEXT;
                    continue;
                }
                if (eventType == 2) {
                    if (xml.getLocalName().equalsIgnoreCase("error")) {
                        String file = "-";
                        int startLine = 0;
                        TreeMap<String, String> specifics = new TreeMap<String, String>();
                        if (tid != null) {
                            specifics.put("tid", tid);
                        }
                        if (threadName != null) {
                            specifics.put("threadname", threadName);
                        }
                        if (auxWhats != null && !auxWhats.isEmpty()) {
                            specifics.put("auxwhats", gson.toJson(auxWhats));
                        }
                        if (stacks != null && !stacks.isEmpty()) {
                            for (StackFrame f : (List)stacks.get(0)) {
                                if (f.file == null || f.file.equals("vg_replace_malloc.c")) continue;
                                file = f.dir == null ? f.file : f.dir + "/" + f.file;
                                startLine = f.line;
                                break;
                            }
                            specifics.put("stacks", gson.toJson(stacks));
                        }
                        if (suppression != null) {
                            specifics.put("suppression", suppression);
                        }
                        violations.add(Violation.violationBuilder().setParser(Parser.VALGRIND).setSeverity(SEVERITY.ERROR).setSource(source).setRule(rule).setFile(file).setStartLine(startLine).setMessage(what).setReporter(reporter).setGroup(group).setSpecifics(specifics).build());
                        element = null;
                        continue;
                    }
                    if (element == Element.UNIQUE && xml.getLocalName().equalsIgnoreCase("unique")) {
                        element = Element.ERROR;
                        continue;
                    }
                    if (element == Element.TID && xml.getLocalName().equalsIgnoreCase("tid")) {
                        element = Element.ERROR;
                        continue;
                    }
                    if (element == Element.THREADNAME && xml.getLocalName().equalsIgnoreCase("threadname")) {
                        element = Element.ERROR;
                        continue;
                    }
                    if (element == Element.KIND && xml.getLocalName().equalsIgnoreCase("kind")) {
                        element = Element.ERROR;
                        continue;
                    }
                    if (element == Element.WHAT && xml.getLocalName().equalsIgnoreCase("what")) {
                        element = Element.ERROR;
                        continue;
                    }
                    if (element == Element.AUXWHAT && xml.getLocalName().equalsIgnoreCase("auxwhat")) {
                        element = Element.ERROR;
                        continue;
                    }
                    if (element == Element.XWHAT && xml.getLocalName().equalsIgnoreCase("xwhat")) {
                        element = Element.ERROR;
                        continue;
                    }
                    if (element == Element.XWHAT_TEXT && xml.getLocalName().equalsIgnoreCase("text")) {
                        element = Element.XWHAT;
                        continue;
                    }
                    if (element == Element.XAUXWHAT && xml.getLocalName().equalsIgnoreCase("xwhat")) {
                        element = Element.ERROR;
                        continue;
                    }
                    if (element == Element.XAUXWHAT_TEXT && xml.getLocalName().equalsIgnoreCase("text")) {
                        element = Element.XAUXWHAT;
                        continue;
                    }
                    if (element == Element.STACK && xml.getLocalName().equalsIgnoreCase("stack")) {
                        if (stacks != null && stack != null) {
                            stacks.add(stack);
                            stack = null;
                        }
                        element = Element.ERROR;
                        continue;
                    }
                    if (element == Element.FRAME && xml.getLocalName().equalsIgnoreCase("frame")) {
                        if (stack != null && frame != null) {
                            stack.add(frame);
                            frame = null;
                        }
                        element = Element.STACK;
                        continue;
                    }
                    if (element == Element.IP && xml.getLocalName().equalsIgnoreCase("ip")) {
                        element = Element.FRAME;
                        continue;
                    }
                    if (element == Element.OBJ && xml.getLocalName().equalsIgnoreCase("obj")) {
                        element = Element.FRAME;
                        continue;
                    }
                    if (element == Element.FN && xml.getLocalName().equalsIgnoreCase("fn")) {
                        element = Element.FRAME;
                        continue;
                    }
                    if (element == Element.DIR && xml.getLocalName().equalsIgnoreCase("dir")) {
                        element = Element.FRAME;
                        continue;
                    }
                    if (element == Element.FILE && xml.getLocalName().equalsIgnoreCase("file")) {
                        element = Element.FRAME;
                        continue;
                    }
                    if (element == Element.LINE && xml.getLocalName().equalsIgnoreCase("line")) {
                        element = Element.FRAME;
                        continue;
                    }
                    if (element == Element.TOOL && xml.getLocalName().equalsIgnoreCase("tool")) {
                        element = null;
                        continue;
                    }
                    if (element == Element.ARGS && xml.getLocalName().equalsIgnoreCase("args")) {
                        element = null;
                        continue;
                    }
                    if (element == Element.ARGV && xml.getLocalName().equalsIgnoreCase("argv")) {
                        element = Element.ARGS;
                        continue;
                    }
                    if (element == Element.EXE && xml.getLocalName().equalsIgnoreCase("exe")) {
                        element = Element.ARGV;
                        continue;
                    }
                    if (element == Element.SUPPRESSION && xml.getLocalName().equalsIgnoreCase("suppression")) {
                        element = Element.ERROR;
                        continue;
                    }
                    if (element != Element.SUPPRESSION_RAWTEXT || !xml.getLocalName().equalsIgnoreCase("rawtext")) continue;
                    element = Element.SUPPRESSION;
                    continue;
                }
                if (element == null || eventType != 4) continue;
                switch (element.ordinal()) {
                    case 0: {
                        reporter = xml.getText();
                        break;
                    }
                    case 3: {
                        source = xml.getText();
                        break;
                    }
                    case 5: {
                        group = xml.getText();
                        break;
                    }
                    case 6: {
                        tid = xml.getText();
                        break;
                    }
                    case 7: {
                        threadName = xml.getText();
                        break;
                    }
                    case 8: {
                        rule = xml.getText();
                        break;
                    }
                    case 9: 
                    case 11: {
                        what = xml.getText();
                        break;
                    }
                    case 12: 
                    case 14: {
                        if (auxWhats == null) break;
                        auxWhats.add(xml.getText());
                        break;
                    }
                    case 17: {
                        if (frame == null) break;
                        frame.ip = xml.getText();
                        break;
                    }
                    case 18: {
                        if (frame == null) break;
                        frame.obj = xml.getText();
                        break;
                    }
                    case 19: {
                        if (frame == null) break;
                        frame.fn = xml.getText();
                        break;
                    }
                    case 20: {
                        if (frame == null) break;
                        frame.dir = xml.getText();
                        break;
                    }
                    case 21: {
                        if (frame == null) break;
                        frame.file = xml.getText();
                        break;
                    }
                    case 22: {
                        if (frame == null) break;
                        frame.line = Integer.parseInt(xml.getText());
                        break;
                    }
                    case 24: {
                        String trimmedText = xml.getText().trim();
                        if (trimmedText.isEmpty()) break;
                        suppression = trimmedText;
                        break;
                    }
                }
            }
        }
        return violations;
    }

    private static enum Element {
        TOOL,
        ARGS,
        ARGV,
        EXE,
        ERROR,
        UNIQUE,
        TID,
        THREADNAME,
        KIND,
        WHAT,
        XWHAT,
        XWHAT_TEXT,
        AUXWHAT,
        XAUXWHAT,
        XAUXWHAT_TEXT,
        STACK,
        FRAME,
        IP,
        OBJ,
        FN,
        DIR,
        FILE,
        LINE,
        SUPPRESSION,
        SUPPRESSION_RAWTEXT;

    }

    private static final class StackFrame {
        public String ip;
        public String obj;
        public String fn;
        public String dir;
        public String file;
        public int line;

        private StackFrame() {
        }

        public String toString() {
            return "StackFrame [ip=" + this.ip + ", obj=" + this.obj + ", fn=" + this.fn + ", dir=" + this.dir + ", file=" + this.file + ", line=" + this.line + "]";
        }
    }
}

