/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class StyleCopParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType != 1 || !xmlr.getLocalName().equalsIgnoreCase("Violation")) continue;
                String section = ViolationParserUtils.getAttribute(xmlr, "Section");
                String source = ViolationParserUtils.getAttribute(xmlr, "Source");
                String ruleNamespace = ViolationParserUtils.getAttribute(xmlr, "RuleNamespace");
                String rule = ViolationParserUtils.getAttribute(xmlr, "Rule");
                String ruleId = ViolationParserUtils.getAttribute(xmlr, "RuleId");
                Integer lineNumber = ViolationParserUtils.getIntegerAttribute(xmlr, "LineNumber");
                String message = xmlr.getElementText().replaceAll("\\s+", " ");
                SEVERITY severity = SEVERITY.INFO;
                String filename = source.replaceAll("\\\\", "/");
                violations.add(Violation.violationBuilder().setParser(Parser.STYLECOP).setMessage(message).setFile(filename).setStartLine(lineNumber).setRule(rule).setSeverity(severity).setSource(filename).setSpecific("section", section).setSpecific("source", source).setSpecific("ruleNamespace", ruleNamespace).setSpecific("rule", rule).setSpecific("ruleId", ruleId).build());
            }
        }
        return violations;
    }
}

