/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.JacocoParserSettings;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class JacocoParser
implements ViolationsParser {
    private final JacocoParserSettings settings;

    public JacocoParser() {
        this.settings = new JacocoParserSettings();
    }

    public JacocoParser(JacocoParserSettings settings) {
        this.settings = settings;
    }

    @Override
    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    public Set<Violation> parseReportOutput(String reportContent, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(reportContent.getBytes(StandardCharsets.UTF_8));){
            MethodViolationBuilder builder = new MethodViolationBuilder();
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                block2 : switch (eventType) {
                    case 1: {
                        switch (xmlr.getLocalName()) {
                            case "package": {
                                builder.setPackageDetails(ViolationParserUtils.getAttribute(xmlr, "name"));
                                break block2;
                            }
                            case "class": {
                                builder.setClassDetails(ViolationParserUtils.getAttribute(xmlr, "sourcefilename"));
                                break block2;
                            }
                            case "method": {
                                builder.setMethodDetails(ViolationParserUtils.getAttribute(xmlr, "name"), ViolationParserUtils.getAttribute(xmlr, "desc"), ViolationParserUtils.findIntegerAttribute(xmlr, "line").orElse(0));
                                break block2;
                            }
                            case "counter": {
                                builder.setCounterDetails(ViolationParserUtils.getAttribute(xmlr, "type"), Integer.parseInt(ViolationParserUtils.getAttribute(xmlr, "covered")), Integer.parseInt(ViolationParserUtils.getAttribute(xmlr, "missed")));
                            }
                        }
                        break;
                    }
                    case 2: {
                        if (!xmlr.getLocalName().equals("method")) break;
                        builder.build(this.settings.getMinLineCount(), this.settings.getMinCoverage()).ifPresent(violations::add);
                    }
                }
            }
        }
        return violations;
    }

    private static class MethodViolationBuilder {
        private String packageName;
        private String fileName;
        private String methodName;
        private String methodDescription;
        private int methodLine;
        private final Map<String, CoverageDetails> coverage = new TreeMap<String, CoverageDetails>();

        private MethodViolationBuilder() {
        }

        public void setPackageDetails(String packageName) {
            this.packageName = packageName;
        }

        public void setClassDetails(String fileName) {
            this.fileName = fileName;
        }

        public void setMethodDetails(String methodName, String methodDescription, int methodLine) {
            this.methodName = methodName;
            this.methodDescription = methodDescription;
            this.methodLine = methodLine;
            this.coverage.clear();
        }

        public void setCounterDetails(String counterName, int covered, int missed) {
            this.coverage.put(counterName, new CoverageDetails(covered, missed));
        }

        public Optional<Violation> build(int minLineCount, double minCoverage) {
            if (this.methodLine == 0) {
                return Optional.empty();
            }
            CoverageDetails cl = this.coverage.get("LINE");
            if (cl.getTotal() < minLineCount) {
                return Optional.empty();
            }
            CoverageDetails ci = this.coverage.get("INSTRUCTION");
            if (ci.getCoverage() >= minCoverage) {
                return Optional.empty();
            }
            return Optional.of(Violation.violationBuilder().setParser(Parser.JACOCO).setStartLine(this.methodLine).setColumn(1).setFile(this.packageName + "/" + this.fileName).setSeverity(SEVERITY.WARN).setMessage(String.format("Covered %d out of %d instructions (%.2f%%) for %s%s", ci.getCovered(), ci.getTotal(), ci.getCoverage() * 100.0, this.methodName, this.methodDescription)).build());
        }
    }

    private static final class CoverageDetails {
        private final int covered;
        private final int missed;

        public CoverageDetails(int covered, int missed) {
            this.covered = covered;
            this.missed = missed;
        }

        public int getCovered() {
            return this.covered;
        }

        public int getMissed() {
            return this.missed;
        }

        public int getTotal() {
            return this.getCovered() + this.getMissed();
        }

        public double getCoverage() {
            return this.getTotal() > 0 ? (double)this.getCovered() * 1.0 / (double)this.getTotal() : 1.0;
        }
    }
}

