/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class JCReportParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            String name = null;
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType != 1) continue;
                if (xmlr.getLocalName().equalsIgnoreCase("file")) {
                    name = ViolationParserUtils.getAttribute(xmlr, "name");
                }
                if (!xmlr.getLocalName().equalsIgnoreCase("item")) continue;
                String findingType = ViolationParserUtils.getAttribute(xmlr, "finding-type");
                Integer line = ViolationParserUtils.getIntegerAttribute(xmlr, "line");
                String message = ViolationParserUtils.getAttribute(xmlr, "message");
                String origin = ViolationParserUtils.getAttribute(xmlr, "origin");
                String severity = ViolationParserUtils.getAttribute(xmlr, "severity");
                Violation violation = Violation.violationBuilder().setParser(Parser.JCREPORT).setFile(name).setMessage(message).setRule(findingType + "(" + origin + ")").setSeverity(this.toSeverity(severity)).setStartLine(line).build();
                violations.add(violation);
            }
        }
        return violations;
    }

    private SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("error")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("cpd")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("warning")) {
            return SEVERITY.WARN;
        }
        if (severity.equalsIgnoreCase("design")) {
            return SEVERITY.WARN;
        }
        if (severity.equalsIgnoreCase("code-style")) {
            return SEVERITY.INFO;
        }
        return SEVERITY.INFO;
    }
}

