/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.StringUtils;
import se.bjurr.violations.violationslib.com.google.gson.Gson;

public class DocFXParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String reportContent, ViolationsLogger violationsLogger) throws Exception {
        String[] lines;
        TreeSet<Violation> violations = new TreeSet<Violation>();
        for (String rawLineToParse : lines = reportContent.split("\\r?\\n")) {
            String fileEncoded;
            Map parsedMap = new Gson().fromJson(rawLineToParse, Map.class);
            String message = (String)parsedMap.get("message");
            String messageSeverity = (String)parsedMap.get("severity");
            String messageSeverityOld = (String)parsedMap.get("message_severity");
            if (messageSeverity == null && messageSeverityOld != null) {
                messageSeverity = messageSeverityOld;
            }
            if ((fileEncoded = (String)parsedMap.get("file")) == null) {
                violationsLogger.log(Level.FINE, "Ignoring " + rawLineToParse + " because there is not file attribute");
                continue;
            }
            String file = StringUtils.htmlDecode(fileEncoded);
            String code = (String)parsedMap.get("code");
            String lineString = (String)parsedMap.get("line");
            Integer lineInt = lineString == null ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(lineString));
            String source = (String)parsedMap.get("source");
            SEVERITY severity = this.getSeverity(messageSeverity);
            violations.add(Violation.violationBuilder().setFile(file).setMessage(message).setParser(Parser.DOCFX).setRule(code).setSeverity(severity).setStartLine(lineInt).setSpecific("source", source).build());
        }
        return violations;
    }

    private SEVERITY getSeverity(String messageSeverity) {
        if (messageSeverity.equalsIgnoreCase("Error")) {
            return SEVERITY.ERROR;
        }
        if (messageSeverity.equalsIgnoreCase("Warning")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

