/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class CPDParser
implements ViolationsParser {
    private SEVERITY getSeverityFromTokens(Integer tokens) {
        if (tokens == null) {
            return SEVERITY.INFO;
        }
        if (tokens < 100) {
            return SEVERITY.INFO;
        }
        if (tokens < 1000) {
            return SEVERITY.WARN;
        }
        return SEVERITY.ERROR;
    }

    private SEVERITY getSeverityFromLines(Integer lines) {
        if (lines == null) {
            return SEVERITY.INFO;
        }
        if (lines < 10) {
            return SEVERITY.INFO;
        }
        if (lines < 50) {
            return SEVERITY.WARN;
        }
        return SEVERITY.ERROR;
    }

    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            boolean isNewPmdCpdFormat = string.contains("xmlns=\"https://pmd-code.org/schema/cpd-report\"");
            if (isNewPmdCpdFormat) {
                this.parseNewPmdCpdFormat(xmlr, violations);
            } else {
                this.parseOldCpdFormat(xmlr, violations);
            }
        }
        return violations;
    }

    private void parseNewPmdCpdFormat(XMLStreamReader xmlr, Set<Violation> violations) throws Exception {
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        Integer lines = null;
        Integer tokens = null;
        while (xmlr.hasNext()) {
            int eventType = xmlr.next();
            if (eventType != 1) continue;
            if (xmlr.getLocalName().equalsIgnoreCase("duplication")) {
                lines = ViolationParserUtils.getIntegerAttribute(xmlr, "lines");
                tokens = ViolationParserUtils.getIntegerAttribute(xmlr, "tokens");
            }
            if (xmlr.getLocalName().equalsIgnoreCase("file")) {
                String path = ViolationParserUtils.getAttribute(xmlr, "path");
                Integer startLine = ViolationParserUtils.getIntegerAttribute(xmlr, "line");
                Integer endLine = ViolationParserUtils.getIntegerAttribute(xmlr, "endline");
                Integer column = ViolationParserUtils.getIntegerAttribute(xmlr, "column");
                Integer endColumn = ViolationParserUtils.getIntegerAttribute(xmlr, "endcolumn");
                files.add(new FileInfo(path, startLine, endLine, column, endColumn));
            }
            if (!xmlr.getLocalName().equalsIgnoreCase("codefragment")) continue;
            String codeFragment = xmlr.getElementText().trim();
            for (FileInfo fileInfo : files) {
                String message = this.createNewFormatMessage(lines, tokens, files.size(), codeFragment);
                Violation violation = Violation.violationBuilder().setParser(Parser.CPD).setFile(fileInfo.path).setMessage(message).setRule("Code Duplication").setSeverity(this.getSeverityFromLines(lines)).setStartLine(fileInfo.startLine).setEndLine(fileInfo.endLine).setColumn(fileInfo.column).setEndColumn(fileInfo.endColumn).build();
                violations.add(violation);
            }
            files.clear();
        }
    }

    private void parseOldCpdFormat(XMLStreamReader xmlr, Set<Violation> violations) throws Exception {
        ArrayList<String> files = new ArrayList<String>();
        ArrayList<Integer> filesLine = new ArrayList<Integer>();
        Integer tokens = null;
        while (xmlr.hasNext()) {
            int eventType = xmlr.next();
            if (eventType != 1) continue;
            if (xmlr.getLocalName().equalsIgnoreCase("duplication")) {
                tokens = ViolationParserUtils.getIntegerAttribute(xmlr, "tokens");
            }
            if (xmlr.getLocalName().equalsIgnoreCase("file")) {
                files.add(ViolationParserUtils.getAttribute(xmlr, "path"));
                filesLine.add(ViolationParserUtils.getIntegerAttribute(xmlr, "line"));
            }
            if (!xmlr.getLocalName().equalsIgnoreCase("codefragment")) continue;
            String codeFragment = xmlr.getElementText().trim();
            for (int i = 0; i < filesLine.size(); ++i) {
                String file = (String)files.get(i);
                Integer line = (Integer)filesLine.get(i);
                Violation violation = Violation.violationBuilder().setParser(Parser.CPD).setFile(file).setMessage(codeFragment).setRule("DUPLICATION").setSeverity(this.getSeverityFromTokens(tokens)).setStartLine(line).build();
                violations.add(violation);
            }
            files.clear();
            filesLine.clear();
        }
    }

    private String createNewFormatMessage(Integer lines, Integer tokens, int fileCount, String codeFragment) {
        StringBuilder message = new StringBuilder();
        message.append("Duplicated code detected");
        if (lines != null) {
            message.append(" (").append(lines).append(" lines");
        }
        if (tokens != null) {
            if (lines != null) {
                message.append(", ");
            } else {
                message.append(" (");
            }
            message.append(tokens).append(" tokens");
        }
        if (lines != null || tokens != null) {
            message.append(")");
        }
        message.append(" found in ").append(fileCount).append(" files");
        if (codeFragment != null && !codeFragment.isEmpty()) {
            Object fragment = codeFragment;
            if (((String)fragment).length() > 200) {
                fragment = ((String)fragment).substring(0, 200) + "...";
            }
            message.append(":\n").append((String)fragment);
        }
        return message.toString();
    }

    private static class FileInfo {
        final String path;
        final Integer startLine;
        final Integer endLine;
        final Integer column;
        final Integer endColumn;

        FileInfo(String path, Integer startLine, Integer endLine, Integer column, Integer endColumn) {
            this.path = path;
            this.startLine = startLine;
            this.endLine = endLine;
            this.column = column;
            this.endColumn = endColumn;
        }
    }
}

