/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.Temporal;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpressionStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class UselessOperationOnImmutableRule
extends AbstractJavaRulechainRule {
    public UselessOperationOnImmutableRule() {
        super(ASTMethodCall.class, new Class[0]);
    }

    public Object visit(ASTMethodCall node, Object data) {
        ASTExpression qualifier = node.getQualifier();
        boolean returnsVoid = node.getTypeMirror().isVoid();
        if (node.getParent() instanceof ASTExpressionStatement && qualifier != null && !returnsVoid) {
            if (TypeTestUtil.isA(String.class, (TypeNode)qualifier)) {
                if (!"getChars".equals(node.getMethodName())) {
                    this.asCtx(data).addViolation((Node)node);
                }
            } else if (TypeTestUtil.isA(BigDecimal.class, (TypeNode)qualifier) || TypeTestUtil.isA(BigInteger.class, (TypeNode)qualifier)) {
                this.asCtx(data).addViolation((Node)node);
            } else if (TypeTestUtil.isA(Temporal.class, (TypeNode)qualifier) || TypeTestUtil.isA(Duration.class, (TypeNode)qualifier) || TypeTestUtil.isA(Period.class, (TypeNode)qualifier)) {
                this.asCtx(data).addViolation((Node)node);
            }
        }
        return null;
    }
}

