/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.function.Predicate;
import net.sourceforge.pmd.lang.java.ast.ASTArrayDimensions;
import net.sourceforge.pmd.lang.java.ast.ASTClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTDefaultValue;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTRecordComponent;
import net.sourceforge.pmd.lang.java.ast.ASTRecordComponentList;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.AbstractExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.AstImplUtil;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ASTMethodDeclaration
extends AbstractExecutableDeclaration<JMethodSymbol> {
    private JMethodSig overriddenMethod = null;

    ASTMethodDeclaration(int id) {
        super(id);
    }

    @Override
    protected <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public boolean isOverridden() {
        return this.overriddenMethod != null;
    }

    public JMethodSig getOverriddenMethod() {
        return this.overriddenMethod;
    }

    void setOverriddenMethod(JMethodSig overriddenMethod) {
        this.overriddenMethod = overriddenMethod;
    }

    public @Nullable ASTRecordComponent getAccessedRecordComponent() {
        if (this.getArity() != 0) {
            return null;
        }
        ASTRecordComponentList components = this.getEnclosingType().getRecordComponents();
        if (components == null) {
            return null;
        }
        return (ASTRecordComponent)components.toStream().first(it -> it.getVarId().getName().equals(this.getName()));
    }

    public boolean isVoid() {
        return this.getResultTypeNode().isVoid();
    }

    public @Nullable ASTDefaultValue getDefaultClause() {
        return AstImplUtil.getChildAs(this, this.getNumChildren() - 1, ASTDefaultValue.class);
    }

    public @NonNull ASTType getResultTypeNode() {
        return (ASTType)this.firstChild(ASTType.class);
    }

    public @Nullable ASTArrayDimensions getExtraDimensions() {
        return (ASTArrayDimensions)this.children(ASTArrayDimensions.class).first();
    }

    public boolean isMainMethod() {
        if (!this.isMainMethodCandidate()) {
            return false;
        }
        if (this.isStatic()) {
            return this.getArity() == 1 || this.hasNoOtherMainMethodSibling(m -> m.isStatic() && m.getArity() == 1);
        }
        if (this.getArity() == 1) {
            return this.hasNoOtherMainMethodSibling(ASTExecutableDeclaration::isStatic);
        }
        return this.hasNoOtherMainMethodSibling(any -> true) && this.ancestors(ASTClassDeclaration.class).firstOpt().map(this::hasParametrizedMain).orElse(false) == false;
    }

    private boolean hasNoOtherMainMethodSibling(Predicate<ASTMethodDeclaration> check) {
        return ((JavaNode)this.getParent()).children(ASTMethodDeclaration.class).toStream().filter(check).noneMatch(m -> m != this && m.isMainMethodCandidate());
    }

    private boolean isMainMethodCandidate() {
        return "main".equals(this.getName()) && !this.hasModifiers(JModifier.PRIVATE, new JModifier[0]) && this.isVoid() && (this.getArity() == 0 || this.getArity() == 1 && TypeTestUtil.isExactlyA(String[].class, (TypeNode)this.getFormalParameters().get(0)));
    }

    private boolean hasParametrizedMain(ASTClassDeclaration astClassType) {
        return astClassType.getTypeMirror().streamMethods(m -> "main".equals(m.getSimpleName()) && m.getArity() == 1 && !m.isStatic()).anyMatch(m -> TypeTestUtil.isExactlyA(String[].class, m.getFormalParameters().get(0)));
    }
}

