/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.registry;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.Report;
import java.util.AbstractMap;
import org.apache.commons.lang3.StringUtils;

public abstract class ParserDescriptor {
    private final String id;
    private final String name;

    ParserDescriptor(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public final String getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public Report.IssueType getType() {
        return Report.IssueType.WARNING;
    }

    public final IssueParser createParser(Option ... options) {
        IssueParser parser = this.create(options);
        parser.setId(this.getId());
        parser.setName(this.getName());
        parser.setType(this.getType());
        return parser;
    }

    protected abstract IssueParser create(Option ... var1);

    public String getPattern() {
        return "";
    }

    public String getHelp() {
        return "";
    }

    public final boolean hasHelp() {
        return StringUtils.isNotBlank((CharSequence)this.getHelp());
    }

    public String getUrl() {
        return "";
    }

    public final boolean hasUrl() {
        return StringUtils.isNotBlank((CharSequence)this.getUrl());
    }

    public String getIconUrl() {
        return "";
    }

    public String getDescription(Issue issue) {
        return issue.getDescription();
    }

    public static class Option
    extends AbstractMap.SimpleImmutableEntry<String, String> {
        private static final long serialVersionUID = 7376822311558465523L;

        public Option(String key, String value) {
            super(key, value);
        }
    }
}

