/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.violations;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.parser.violations.AbstractViolationAdapter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.SarifParser;

public class SarifAdapter
extends AbstractViolationAdapter {
    private static final long serialVersionUID = -5699747899173867285L;
    private static final Pattern WINDOWS_PATH_ON_UNIX = Pattern.compile("^/[a-zA-Z]:.*");

    SarifParser createParser() {
        return new SarifParser();
    }

    @Override
    void extractAdditionalProperties(IssueBuilder builder, Violation violation) {
        try {
            URI uri = new URI(violation.getFile());
            String path = uri.getPath();
            if (path != null) {
                builder.setFileName(this.removePrefix(path));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    @Override
    boolean isValid(Violation violation) {
        return violation.getSpecifics().getOrDefault("suppressed", "false").equals("false");
    }

    private String removePrefix(String fileName) {
        if (WINDOWS_PATH_ON_UNIX.matcher(fileName).matches()) {
            return fileName.substring(1);
        }
        return fileName;
    }
}

