/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import j2html.TagCreator;
import j2html.tags.DomContent;
import org.json.JSONArray;
import org.json.JSONObject;

public class YoctoScannerParser
extends JsonIssueParser {
    private static final String VALUE_NOT_SET = "-";
    private static final long serialVersionUID = 1L;
    private static final double INVALID_SCORE = -1.0;

    @Override
    protected void parseJsonObject(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        JSONArray packages = jsonReport.optJSONArray("package");
        if (packages != null) {
            this.parseResources(report, packages, issueBuilder);
        }
    }

    private void parseResources(Report report, JSONArray packages, IssueBuilder issueBuilder) {
        for (int i = 0; i < packages.length(); ++i) {
            JSONObject resourceWrapper;
            Object item = packages.get(i);
            if (!(item instanceof JSONObject) || (resourceWrapper = (JSONObject)item).isNull("issue")) continue;
            this.parseVulnerabilities(report, issueBuilder, resourceWrapper);
        }
    }

    private void parseVulnerabilities(Report report, IssueBuilder issueBuilder, JSONObject resourceWrapper) {
        JSONArray vulnerabilities = resourceWrapper.getJSONArray("issue");
        for (Object vulnerability : vulnerabilities) {
            JSONObject obj;
            String status;
            boolean unpatched;
            if (!(vulnerability instanceof JSONObject) || !(unpatched = "Unpatched".equals(status = (obj = (JSONObject)vulnerability).getString("status")))) continue;
            report.add(this.convertToIssue(resourceWrapper, obj, issueBuilder));
        }
    }

    private Issue convertToIssue(JSONObject resource, JSONObject vulnerability, IssueBuilder issueBuilder) {
        String packageName = resource.getString("name");
        String fileName = vulnerability.optString("id", "UNKNOWN");
        return issueBuilder.setType(fileName).setFileName(packageName).setSeverity(this.mapSeverity(vulnerability)).setMessage(vulnerability.optString("id", "UNKNOWN")).setDescription(this.formatDescription(packageName, resource, vulnerability)).buildAndClean();
    }

    private Severity mapSeverity(JSONObject vulnerability) {
        boolean hasScoreV3 = vulnerability.has("scorev3");
        double score = hasScoreV3 ? vulnerability.getDouble("scorev3") : -1.0;
        if (score <= 0.0) {
            score = vulnerability.getDouble("scorev2");
        }
        if (score >= 0.0 && score < 4.0) {
            return Severity.WARNING_LOW;
        }
        if (score >= 4.0 && score < 7.0) {
            return Severity.WARNING_NORMAL;
        }
        if (score >= 7.0 && score <= 10.0) {
            return Severity.WARNING_HIGH;
        }
        return Severity.ERROR;
    }

    private String formatDescription(String packageName, JSONObject resource, JSONObject vulnerability) {
        String version = resource.optString("version", VALUE_NOT_SET);
        String layer = resource.optString("layer", "UNKOWN");
        String vector = vulnerability.optString("vector", "UNKOWN");
        String link = vulnerability.optString("link", "UNKOWN");
        String description = vulnerability.optString("summary", "");
        return TagCreator.join((Object[])new Object[]{TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)"Package: "), TagCreator.text((String)packageName)}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)"Version: "), TagCreator.text((String)version)}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)"Link: "), TagCreator.a((String)link).withHref(link)}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)"Yocto Layer: "), TagCreator.text((String)layer)}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)"Vector: "), TagCreator.text((String)vector)}), TagCreator.p((DomContent[])new DomContent[]{TagCreator.text((String)description)})}).render();
    }
}

