/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class MsBuildParser
extends LookaheadParser {
    private static final long serialVersionUID = -2141974437420906595L;
    public static final String COMMAND_LINE_WARNING_PATTERN = "(?:^(?:.*)Command line warning ([A-Za-z0-9]+):\\s*(.*)\\s*\\[(.*)\\])";
    public static final String OPTIONAL_LINE_NUMBER_PATTERN = "(?:\\s*(?:\\d+|\\d+:\\d+)>)?";
    private static final String LINE_COLUMN_PATTERN = "\\((?:(\\d+),(\\d+),(\\d+),(\\d+)|(\\d+)(?:-(\\d+))?(?:,(\\d+)(?:-(\\d+))?)?)\\)";
    public static final String FILE_NAME_PATTERN = "(?:(?:(?:(.*?)\\((?:(\\d+),(\\d+),(\\d+),(\\d+)|(\\d+)(?:-(\\d+))?(?:,(\\d+)(?:-(\\d+))?)?)\\)|.*LINK)\\s*:|(.*):)";
    public static final String SEVERITY_PATTERN = "\\s*((?:[A-z-_]+\\s)?(?:[Nn]ote|[Ii]nfo|[Ww]arning|[Hh]int|(?:fatal\\s*)?[Ee]rror))[^A-Za-z0-9]\\s*:?\\s*";
    public static final String CATEGORY_PATTERN = "([A-Za-z0-9\\-_]+)?\\s*:\\s";
    public static final String TYPE_PATTERN = "(?:\\s*([A-Za-z0-9.]+)\\s*:)?\\s*";
    public static final String MESSAGE_PATTERN = "(.*?)";
    public static final String PROJECT_DIR_PATTERN = "(?: \\[([^\\]]*)[/\\\\][^\\]\\\\]+\\])?";
    private static final String DELPHI_SIMPLE_PATTERN = "^\\s*([A-Za-z]:[^\\(]+\\.(?:pas|dpr|dpk|dproj))\\((\\d+)\\)\\s+([Ww]arning|[Hh]int)\\s*:\\s*([A-Za-z0-9]+)\\s+(.*)$";
    private static final String MS_BUILD_WARNING_PATTERN = "(?:^(?:.*)Command line warning ([A-Za-z0-9]+):\\s*(.*)\\s*\\[(.*)\\])|^\\s*([A-Za-z]:[^\\(]+\\.(?:pas|dpr|dpk|dproj))\\((\\d+)\\)\\s+([Ww]arning|[Hh]int)\\s*:\\s*([A-Za-z0-9]+)\\s+(.*)$|^(?:.*\\[[^]]*\\])?\\s*(?:(?:\\s*(?:\\d+|\\d+:\\d+)>)?(?:(?:(?:(.*?)\\((?:(\\d+),(\\d+),(\\d+),(\\d+)|(\\d+)(?:-(\\d+))?(?:,(\\d+)(?:-(\\d+))?)?)\\)|.*LINK)\\s*:|(.*):)\\s*((?:[A-z-_]+\\s)?(?:[Nn]ote|[Ii]nfo|[Ww]arning|[Hh]int|(?:fatal\\s*)?[Ee]rror))[^A-Za-z0-9]\\s*:?\\s*([A-Za-z0-9\\-_]+)?\\s*:\\s(?:\\s*([A-Za-z0-9.]+)\\s*:)?\\s*(.*?)(?: \\[([^\\]]*)[/\\\\][^\\]\\\\]+\\])?))$";
    private static final Pattern TOOL_NAME_PATTERN = Pattern.compile("^(?:EXEC|NMAKE|LINK|MSBUILD|MSBuild|link|nmake|msbuild|cl|rs)$|^[^/\\\\]*\\.exe$|^<[^>]+>$", 2);
    private static final Pattern LINKER_CAUSE = Pattern.compile(".*imported by '([A-Za-z0-9\\-_.]+)'.*");
    private static final String EXPECTED_CATEGORY = "Expected";
    private static final String MSBUILD = "MSBUILD";
    private static final Pattern HEADER_COMPILE_MESSAGE = Pattern.compile("\\(compiling source file .*\\)");
    private static final Pattern DELPHI_FILE_PATTERN = Pattern.compile("^\\s*([^:]+\\.(?:pas|dpr|dpk|dproj))\\((\\d+)\\)\\s+(?:[Ww]arning|[Hh]int)\\s*:\\s*([A-Za-z0-9]+)\\s+(.*)$");

    public MsBuildParser() {
        super(MS_BUILD_WARNING_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return true;
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        if (StringUtils.isNotBlank((CharSequence)matcher.group(4))) {
            return this.createDelphiSimpleIssue(matcher, builder);
        }
        String fileName = this.determineFileName(matcher);
        if (this.isToolName(fileName)) {
            return Optional.empty();
        }
        String message = matcher.group(22);
        Optional<Issue> delphiIssue = this.createDelphiEmbeddedIssue(matcher, message, builder);
        if (delphiIssue.isPresent()) {
            return delphiIssue;
        }
        builder.setFileName(fileName);
        if (StringUtils.isNotBlank((CharSequence)matcher.group(2))) {
            return builder.setLineStart(0).setCategory(matcher.group(1)).setMessage(matcher.group(2)).setSeverity(Severity.WARNING_NORMAL).buildOptional();
        }
        this.setLineAndColumnRanges(matcher, builder);
        if (StringUtils.isNotEmpty((CharSequence)matcher.group(21))) {
            return builder.setCategory(matcher.group(20)).setType(matcher.group(21)).setMessage(matcher.group(22)).setSeverity(Severity.guessFromString(matcher.group(19))).buildOptional();
        }
        return this.createStandardIssue(matcher, message, builder);
    }

    private Optional<Issue> createDelphiSimpleIssue(Matcher matcher, IssueBuilder builder) {
        String delphiMessage = matcher.group(8);
        if (delphiMessage == null) {
            delphiMessage = "";
        }
        return builder.setFileName(matcher.group(4)).setLineStart(matcher.group(5)).setCategory(matcher.group(7)).setMessage(delphiMessage).setSeverity(Severity.guessFromString(matcher.group(6))).buildOptional();
    }

    private Optional<Issue> createDelphiEmbeddedIssue(Matcher matcher, String message, IssueBuilder builder) {
        Matcher delphiMatcher;
        if (message != null && (delphiMatcher = DELPHI_FILE_PATTERN.matcher(message)).matches()) {
            String fileName = delphiMatcher.group(1);
            String lineNumber = delphiMatcher.group(2);
            String delphiCategory = delphiMatcher.group(3);
            String delphiMessage = delphiMatcher.group(4);
            return builder.setFileName(fileName).setLineStart(lineNumber).setCategory(delphiCategory).setMessage(delphiMessage).setSeverity(Severity.guessFromString(matcher.group(19))).buildOptional();
        }
        return Optional.empty();
    }

    private void setLineAndColumnRanges(Matcher matcher, IssueBuilder builder) {
        if (StringUtils.isNotEmpty((CharSequence)matcher.group(10))) {
            builder.setLineStart(matcher.group(10)).setColumnStart(matcher.group(11)).setLineEnd(matcher.group(12)).setColumnEnd(matcher.group(13));
        }
        if (StringUtils.isNotEmpty((CharSequence)matcher.group(14))) {
            builder.setLineStart(matcher.group(14)).setColumnStart(matcher.group(16)).setLineEnd(matcher.group(15)).setColumnEnd(matcher.group(17));
        }
    }

    private Optional<Issue> createStandardIssue(Matcher matcher, String message, IssueBuilder builder) {
        String category = matcher.group(20);
        if (EXPECTED_CATEGORY.equals(category)) {
            return Optional.empty();
        }
        String messageText = message == null ? "" : message;
        String cleanedMessage = HEADER_COMPILE_MESSAGE.matcher(messageText).replaceAll("");
        return builder.setCategory(category).setMessage(cleanedMessage).setSeverity(Severity.guessFromString(matcher.group(19))).buildOptional();
    }

    private boolean isToolName(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName) || "-".equals(fileName) || "unknown.file".equals(fileName)) {
            return true;
        }
        String baseFileName = FilenameUtils.getName((String)fileName).trim();
        baseFileName = baseFileName.replaceAll("^\\d{1,2}:\\d{2}:\\d{2}\\s+", "");
        return TOOL_NAME_PATTERN.matcher(baseFileName).matches();
    }

    private String determineFileName(Matcher matcher) {
        String fileName = this.extractFileNameFromGroups(matcher);
        fileName = this.resolveFileName(fileName, matcher);
        return this.normalizeFileName(fileName, matcher.group(23));
    }

    private String extractFileNameFromGroups(Matcher matcher) {
        if (StringUtils.isNotBlank((CharSequence)matcher.group(3))) {
            return matcher.group(3);
        }
        if (StringUtils.isNotBlank((CharSequence)matcher.group(18))) {
            return matcher.group(18);
        }
        return matcher.group(9);
    }

    private String resolveFileName(String fileName, Matcher matcher) {
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            return fileName;
        }
        Matcher linker = LINKER_CAUSE.matcher(matcher.group(22));
        if (linker.matches()) {
            return linker.group(1);
        }
        String extractedFileName = StringUtils.substringBetween((String)matcher.group(22), (String)"'");
        return StringUtils.isNotBlank((CharSequence)extractedFileName) ? extractedFileName : "unknown.file";
    }

    private String normalizeFileName(String fileName, String projectDir) {
        String normalizedFileName = fileName;
        if (this.canResolveRelativeFileName(normalizedFileName, projectDir)) {
            normalizedFileName = FilenameUtils.concat((String)projectDir, (String)normalizedFileName);
        }
        if (MSBUILD.equals(normalizedFileName.trim())) {
            return "-";
        }
        if (this.containsInvalidPathCharacters(normalizedFileName)) {
            return "-";
        }
        return normalizedFileName;
    }

    private boolean containsInvalidPathCharacters(String fileName) {
        if (fileName.contains("<") || fileName.contains(">") || fileName.contains("|")) {
            return true;
        }
        return fileName.contains("\"") || fileName.contains("?") || fileName.contains("*");
    }

    private boolean canResolveRelativeFileName(String fileName, String projectDir) {
        return StringUtils.isNotBlank((CharSequence)projectDir) && FilenameUtils.getPrefixLength((String)fileName) == 0 && !MSBUILD.equals(fileName.trim());
    }
}

