/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.SecureDigester;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xml.sax.SAXException;

public class JcReportParser
extends IssueParser {
    private static final long serialVersionUID = -1302787609831475403L;

    @Override
    public Report parseReport(ReaderFactory reader) {
        try (IssueBuilder issueBuilder = new IssueBuilder();){
            JcReport report = this.createReport(reader);
            Report warnings = new Report();
            for (int i = 0; i < report.getFiles().size(); ++i) {
                File file = report.getFiles().get(i);
                for (int j = 0; j < file.getItems().size(); ++j) {
                    Item item = file.getItems().get(j);
                    issueBuilder.setFileName(file.getName()).setLineStart(item.getLine()).setColumnStart(item.getColumn()).setColumnEnd(item.getEndcolumn()).setCategory(item.getFindingtype()).setPackageName(file.getPackageName()).setMessage(item.getMessage()).guessSeverity(item.getSeverity());
                    warnings.add(issueBuilder.buildAndClean());
                }
            }
            Report report2 = warnings;
            return report2;
        }
    }

    JcReport createReport(ReaderFactory readerFactory) throws ParsingException {
        JcReport jcReport;
        block8: {
            SecureDigester digester = new SecureDigester(JcReportParser.class);
            String report = "report";
            digester.addObjectCreate(report, JcReport.class);
            digester.addSetProperties(report);
            String file = "report/file";
            digester.addObjectCreate(file, File.class);
            digester.addSetProperties(file, "package", "packageName");
            digester.addSetProperties(file, "src-dir", "srcdir");
            digester.addSetProperties(file);
            digester.addSetNext(file, "addFile", File.class.getName());
            String item = "report/file/item";
            digester.addObjectCreate(item, Item.class);
            digester.addSetProperties(item);
            digester.addSetProperties(item, "finding-type", "findingtype");
            digester.addSetProperties(item, "end-line", "endline");
            digester.addSetProperties(item, "end-column", "endcolumn");
            digester.addSetNext(item, "addItem", Item.class.getName());
            Reader reader = readerFactory.create();
            try {
                jcReport = (JcReport)digester.parse(reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SAXException e) {
                    throw new ParsingException(e, readerFactory);
                }
            }
            reader.close();
        }
        return jcReport;
    }

    @SuppressFBWarnings(value={"EI"})
    public static class JcReport {
        private List<File> files = new ArrayList<File>();

        public List<File> getFiles() {
            return Collections.unmodifiableList(this.files);
        }

        public void setFiles(List<File> files) {
            this.files = files;
        }

        public void addFile(File file) {
            this.files.add(file);
        }
    }

    public static class File {
        @CheckForNull
        private String name;
        @CheckForNull
        private String packageName;
        @CheckForNull
        private String srcdir;
        private final List<Item> items = new ArrayList<Item>();
        @CheckForNull
        private String level;
        @CheckForNull
        private String loc;
        @CheckForNull
        private String classname;

        public List<Item> getItems() {
            return Collections.unmodifiableList(this.items);
        }

        public void addItem(Item item) {
            this.items.add(item);
        }

        @CheckForNull
        public String getClassname() {
            return this.classname;
        }

        public void setClassname(@CheckForNull String classname) {
            this.classname = classname;
        }

        @CheckForNull
        public String getLevel() {
            return this.level;
        }

        public void setLevel(@CheckForNull String level) {
            this.level = level;
        }

        @CheckForNull
        public String getLoc() {
            return this.loc;
        }

        public void setLoc(@CheckForNull String loc) {
            this.loc = loc;
        }

        @CheckForNull
        public String getName() {
            return this.name;
        }

        public void setName(@CheckForNull String name) {
            this.name = name;
        }

        @CheckForNull
        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(@CheckForNull String packageName) {
            this.packageName = packageName;
        }

        @CheckForNull
        public String getSrcdir() {
            return this.srcdir;
        }

        public void setSrcdir(@CheckForNull String srcdir) {
            this.srcdir = srcdir;
        }
    }

    public static class Item {
        @CheckForNull
        private String column;
        @CheckForNull
        private String findingtype;
        @CheckForNull
        private String line;
        @CheckForNull
        private String message;
        @CheckForNull
        private String origin;
        @CheckForNull
        private String severity;
        @CheckForNull
        private String endcolumn;
        @CheckForNull
        private String endline;

        @CheckForNull
        public String getColumn() {
            return this.column;
        }

        public void setColumn(@CheckForNull String column) {
            this.column = column;
        }

        @CheckForNull
        public String getFindingtype() {
            return this.findingtype;
        }

        public void setFindingtype(@CheckForNull String findingtype) {
            this.findingtype = findingtype;
        }

        @CheckForNull
        public String getLine() {
            return this.line;
        }

        public void setLine(@CheckForNull String line) {
            this.line = line;
        }

        @CheckForNull
        public String getMessage() {
            return this.message;
        }

        public void setMessage(@CheckForNull String message) {
            this.message = message;
        }

        @CheckForNull
        public String getOrigin() {
            return this.origin;
        }

        public void setOrigin(@CheckForNull String origin) {
            this.origin = origin;
        }

        @CheckForNull
        public String getSeverity() {
            return this.severity;
        }

        public void setSeverity(@CheckForNull String severity) {
            this.severity = severity;
        }

        @CheckForNull
        public String getEndline() {
            return this.endline;
        }

        public void setEndline(@CheckForNull String endline) {
            this.endline = endline;
        }

        @CheckForNull
        public String getEndcolumn() {
            return this.endcolumn;
        }

        public void setEndcolumn(@CheckForNull String endcolumn) {
            this.endcolumn = endcolumn;
        }
    }
}

