/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.Gcc4CompilerParser;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class Gcc4Cc1Parser
extends LookaheadParser {
    private static final long serialVersionUID = 1L;
    private static final String GCC_CC1_WARNING_PATTERN = "^(?:In .+?:\\s*)?(?<compiler>cc1(?:plus)?):\\s*(?<severity>warning|error|note):\\s*(?<message>.*)$";

    public Gcc4Cc1Parser() {
        super(GCC_CC1_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String compilerName = matcher.group("compiler");
        String severityLevel = matcher.group("severity");
        String messageContent = matcher.group("message");
        if (StringUtils.isBlank((CharSequence)compilerName) || StringUtils.isBlank((CharSequence)severityLevel) || StringUtils.isBlank((CharSequence)messageContent)) {
            return Optional.empty();
        }
        StringBuilder completeMessage = new StringBuilder(messageContent);
        while (lookahead.hasNext() && Gcc4CompilerParser.isMessageContinuation(lookahead, false)) {
            completeMessage.append(' ');
            completeMessage.append(lookahead.next());
        }
        String message = completeMessage.toString();
        String category = this.extractCategory(message);
        return builder.setFileName("-").setLineStart(0).setCategory(category).setMessage(StringEscapeUtils.escapeXml10((String)message)).setSeverity(Severity.guessFromString(severityLevel)).buildOptional();
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("warning") || line.contains("error") || line.contains("note");
    }

    private String extractCategory(String message) {
        int start = message.lastIndexOf("[-W");
        if (start == -1) {
            return "GCC warning";
        }
        int end = message.indexOf(93, start);
        if (end == -1) {
            return "GCC warning";
        }
        String category = message.substring(start + 3, end);
        int equalsPos = category.indexOf(61);
        if (equalsPos != -1) {
            return category.substring(0, equalsPos);
        }
        return category;
    }
}

