/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.util.XmlElementUtil;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FxCopParser
extends IssueParser {
    private static final long serialVersionUID = -7208558002331355408L;
    private static final int CAPACITY = 1024;

    @Override
    public Report parseReport(ReaderFactory readerFactory) throws ParsingException, ParsingCanceledException {
        return new XmlParser().parse(readerFactory);
    }

    private static class XmlParser {
        private final Report warnings = new Report();
        private final FxCopRuleSet ruleSet = new FxCopRuleSet();

        private XmlParser() {
        }

        Report parse(ReaderFactory readerFactory) throws ParsingException, ParsingCanceledException {
            try (IssueBuilder issueBuilder = new IssueBuilder();){
                Document doc = readerFactory.readDocument();
                NodeList mainNode = doc.getElementsByTagName("FxCopReport");
                Element rootElement = (Element)mainNode.item(0);
                this.parseRules(rootElement, issueBuilder);
                this.parseNamespaces(rootElement, issueBuilder);
                this.parseTargets(rootElement, issueBuilder);
                Report report = this.warnings;
                return report;
            }
        }

        private void parseRules(Element rootElement, IssueBuilder issueBuilder) {
            Optional<Element> rulesElement = XmlElementUtil.getFirstChildElementByName(rootElement, "Rules");
            if (rulesElement.isPresent()) {
                for (Element rule : XmlElementUtil.getChildElementsByName(rulesElement.get(), "Rule")) {
                    this.ruleSet.addRule(rule);
                }
            }
        }

        private void parseTargets(Element rootElement, IssueBuilder issueBuilder) {
            Optional<Element> targetsElement = XmlElementUtil.getFirstChildElementByName(rootElement, "Targets");
            if (targetsElement.isPresent()) {
                for (Element target : XmlElementUtil.getChildElementsByName(targetsElement.get(), "Target")) {
                    String name = this.getString(target, "Name");
                    this.parseMessages(target, name, issueBuilder);
                    this.parseModules(target, name, issueBuilder);
                    this.parseResources(target, name, issueBuilder);
                }
            }
        }

        private void parseResources(Element target, String parentName, IssueBuilder issueBuilder) {
            Optional<Element> resources = XmlElementUtil.getFirstChildElementByName(target, "Resources");
            if (resources.isPresent()) {
                for (Element resource : XmlElementUtil.getChildElementsByName(resources.get(), "Resource")) {
                    String name = this.getString(resource, "Name");
                    this.parseMessages(resource, name, issueBuilder);
                }
            }
        }

        private void parseModules(Element target, String parentName, IssueBuilder issueBuilder) {
            Optional<Element> modulesElement = XmlElementUtil.getFirstChildElementByName(target, "Modules");
            if (modulesElement.isPresent()) {
                for (Element module : XmlElementUtil.getChildElementsByName(modulesElement.get(), "Module")) {
                    String name = this.getString(module, "Name");
                    this.parseMessages(module, name, issueBuilder);
                    this.parseNamespaces(module, issueBuilder);
                }
            }
        }

        private void parseNamespaces(Element rootElement, IssueBuilder issueBuilder) {
            Optional<Element> namespacesElement = XmlElementUtil.getFirstChildElementByName(rootElement, "Namespaces");
            if (namespacesElement.isPresent()) {
                for (Element namespace : XmlElementUtil.getChildElementsByName(namespacesElement.get(), "Namespace")) {
                    String name = this.getString(namespace, "Name");
                    this.parseMessages(namespace, name, issueBuilder);
                    this.parseTypes(namespace, name, issueBuilder);
                }
            }
        }

        private void parseTypes(Element typesElement, String parentName, IssueBuilder issueBuilder) {
            Optional<Element> types = XmlElementUtil.getFirstChildElementByName(typesElement, "Types");
            if (types.isPresent()) {
                for (Element type : XmlElementUtil.getChildElementsByName(types.get(), "Type")) {
                    String name = parentName + "." + this.getString(type, "Name");
                    this.parseMessages(type, name, issueBuilder);
                    this.parseMembers(type, name, issueBuilder);
                }
            }
        }

        private void parseMembers(Element members, String parentName, IssueBuilder issueBuilder) {
            Optional<Element> membersElement = XmlElementUtil.getFirstChildElementByName(members, "Members");
            if (membersElement.isPresent()) {
                for (Element member : XmlElementUtil.getChildElementsByName(membersElement.get(), "Member")) {
                    this.parseMember(member, parentName, issueBuilder);
                }
            }
        }

        private void parseAccessors(Element accessorsElement, String parentName, IssueBuilder issueBuilder) {
            Optional<Element> accessors = XmlElementUtil.getFirstChildElementByName(accessorsElement, "Accessors");
            if (accessors.isPresent()) {
                for (Element member : XmlElementUtil.getChildElementsByName(accessors.get(), "Accessor")) {
                    this.parseMember(member, parentName, issueBuilder);
                }
            }
        }

        private void parseMember(Element member, String parentName, IssueBuilder issueBuilder) {
            this.parseMessages(member, parentName, issueBuilder);
            this.parseAccessors(member, parentName, issueBuilder);
        }

        private void parseMessages(Element messages, String parentName, IssueBuilder issueBuilder) {
            Optional<Element> messagesElement = XmlElementUtil.getFirstChildElementByName(messages, "Messages");
            if (messagesElement.isPresent()) {
                for (Element message : XmlElementUtil.getChildElementsByName(messagesElement.get(), "Message")) {
                    for (Element issue : XmlElementUtil.getChildElementsByName(message, "Issue")) {
                        this.parseIssue(issue, message, parentName, issueBuilder);
                    }
                }
            }
        }

        private void parseIssue(Element issue, Element parent, String parentName, IssueBuilder issueBuilder) {
            String typeName = this.getString(parent, "TypeName");
            String category = this.getString(parent, "Category");
            String checkId = this.getString(parent, "CheckId");
            String issueLevel = this.getString(issue, "Level");
            StringBuilder msgBuilder = new StringBuilder(1024);
            FxCopRule rule = this.ruleSet.getRule(category, checkId);
            if (rule == null) {
                msgBuilder.append(typeName);
            } else {
                msgBuilder.append("<a href=\"");
                msgBuilder.append(rule.getUrl());
                msgBuilder.append("\">");
                msgBuilder.append(typeName);
                msgBuilder.append("</a>");
            }
            msgBuilder.append(" - ");
            msgBuilder.append(issue.getTextContent());
            String filePath = this.getString(issue, "Path");
            String fileName = this.getString(issue, "File");
            String fileLine = this.getString(issue, "Line");
            issueBuilder.setFileName(filePath + "/" + fileName).setLineStart(fileLine).setCategory(category).setMessage(msgBuilder.toString()).guessSeverity(issueLevel);
            if (rule != null) {
                issueBuilder.setDescription(rule.getDescription());
            }
            this.warnings.add(issueBuilder.buildAndClean());
        }

        private String getString(Element element, String name) {
            if (element.hasAttribute(name)) {
                return element.getAttribute(name);
            }
            return "";
        }
    }

    public static class FxCopRuleSet {
        private final Map<String, FxCopRule> rules = new HashMap<String, FxCopRule>();

        public void addRule(Element element) {
            FxCopRule rule = new FxCopRule(element.getAttribute("TypeName"), element.getAttribute("Category"), element.getAttribute("CheckId"));
            rule.setUrl(this.getNamedTagText(element, "Url"));
            rule.setDescription(this.getNamedTagText(element, "Description"));
            rule.setName(this.getNamedTagText(element, "Name"));
            this.rules.put(this.getRuleKey(rule.getCategory(), rule.getCheckId()), rule);
        }

        private String getNamedTagText(Element element, String tagName) {
            Optional<Element> foundElement = XmlElementUtil.getFirstChildElementByName(element, tagName);
            if (foundElement.isPresent()) {
                return foundElement.get().getTextContent();
            }
            return "";
        }

        public boolean contains(String category, String checkId) {
            return this.rules.containsKey(this.getRuleKey(category, checkId));
        }

        @CheckForNull
        public FxCopRule getRule(String category, String checkId) {
            String key = this.getRuleKey(category, checkId);
            FxCopRule rule = null;
            if (this.rules.containsKey(key)) {
                rule = this.rules.get(key);
            }
            return rule;
        }

        private String getRuleKey(String category, String checkId) {
            return category + "#" + checkId;
        }
    }

    public static class FxCopRule {
        private final String typeName;
        private final String category;
        private final String checkId;
        @CheckForNull
        private String name;
        @CheckForNull
        private String url;
        @CheckForNull
        private String description;

        public FxCopRule(String typeName, String category, String checkId) {
            this.typeName = typeName;
            this.category = category;
            this.checkId = checkId;
        }

        @CheckForNull
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @CheckForNull
        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        @CheckForNull
        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getCategory() {
            return this.category;
        }

        public String getCheckId() {
            return this.checkId;
        }
    }
}

