/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class EsLintParser
extends JsonIssueParser {
    private static final long serialVersionUID = -2455926786089596397L;

    @Override
    protected void parseJsonObject(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        JSONArray results = jsonReport.getJSONArray("results");
        for (Object result : results) {
            if (!(result instanceof JSONObject)) continue;
            JSONObject object = (JSONObject)result;
            this.parseMessages(report, object, issueBuilder);
        }
    }

    @Override
    protected void parseJsonArray(Report report, JSONArray jsonReport, IssueBuilder issueBuilder) {
        for (Object issue : jsonReport) {
            if (!(issue instanceof JSONObject)) continue;
            JSONObject object = (JSONObject)issue;
            this.parseMessages(report, object, issueBuilder);
        }
    }

    private void parseMessages(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        issueBuilder.setFileName(jsonReport.getString("filePath"));
        JSONArray messages = jsonReport.getJSONArray("messages");
        for (Object issue : messages) {
            if (!(issue instanceof JSONObject)) continue;
            JSONObject message = (JSONObject)issue;
            report.add(this.convertToIssue(message, issueBuilder));
        }
    }

    private Issue convertToIssue(JSONObject jsonIssue, IssueBuilder issueBuilder) {
        return issueBuilder.setType(jsonIssue.optString("ruleId", "None")).setMessage(jsonIssue.optString("message", "n/a")).setDescription(EsLintParser.formatDescription(jsonIssue)).setSeverity(EsLintParser.toSeverity(jsonIssue.optInt("severity"))).setLineStart(jsonIssue.optInt("line")).setColumnStart(jsonIssue.optInt("column")).setLineEnd(jsonIssue.optInt("endLine")).setColumnEnd(jsonIssue.optInt("endColumn")).build();
    }

    private static String formatDescription(JSONObject jsonIssue) {
        String text;
        JSONObject fix = jsonIssue.optJSONObject("fix");
        if (fix != null && StringUtils.isNotBlank((CharSequence)(text = fix.getString("text")))) {
            return TagCreator.join((Object[])new Object[]{TagCreator.p((String)"Fix:"), TagCreator.pre().with((DomContent)TagCreator.code((String)text))}).render();
        }
        JSONArray suggestions = jsonIssue.optJSONArray("suggestions");
        if (suggestions != null) {
            ContainerTag ul = TagCreator.ul();
            for (Object issue : suggestions) {
                if (!(issue instanceof JSONObject)) continue;
                JSONObject suggestion = (JSONObject)issue;
                ul.with((DomContent)TagCreator.li((DomContent[])new DomContent[]{EsLintParser.formatSuggestion(suggestion)}));
            }
            return TagCreator.join((Object[])new Object[]{TagCreator.p((String)"Suggestions:"), ul}).render();
        }
        return "";
    }

    private static DomContent formatSuggestion(JSONObject suggestion) {
        String desc = suggestion.getString("desc");
        JSONObject fix = suggestion.getJSONObject("fix");
        String text = fix.getString("text");
        return StringUtils.isBlank((CharSequence)text) ? TagCreator.p((String)desc) : TagCreator.join((Object[])new Object[]{TagCreator.p((String)desc), TagCreator.pre().with((DomContent)TagCreator.code((String)text))});
    }

    private static Severity toSeverity(int severity) {
        if (severity == 1) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.ERROR;
    }
}

