/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class ClangTidyParser
extends LookaheadParser {
    private static final long serialVersionUID = -3015592762345283182L;
    private static final String CLANG_TIDY_WARNING_PATTERN = "(?:clang-tidy\\S* (?:-\\S+ )*|)((?<file>.+):(?<line>\\d+):(?<column>\\d+): |)(?<severity>warning|error): (?<message>.*?) \\[(?<category>[^\\s]*?)\\]$";
    private static final int CATEGORY_PARTS_COUNT = 2;

    public ClangTidyParser() {
        super(CLANG_TIDY_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String category = matcher.group("category");
        if (category.startsWith("-W")) {
            return Optional.empty();
        }
        this.addDescriptionIfAvailable(builder, category);
        return builder.setFileName(matcher.group("file")).setSeverity(Severity.guessFromString(matcher.group("severity"))).setLineStart(matcher.group("line")).setColumnStart(matcher.group("column")).setCategory(category).setMessage(matcher.group("message")).buildOptional();
    }

    private void addDescriptionIfAvailable(IssueBuilder builder, String category) {
        String[] parts;
        if (!(StringUtils.isBlank((CharSequence)category) || category.startsWith("clang-diagnostic-") || category.startsWith("clang-analyzer-") || (parts = category.split("-", 2)).length != 2)) {
            String module = parts[0];
            String check = parts[1];
            String url = String.format("https://clang.llvm.org/extra/clang-tidy/checks/%s/%s.html", module, check);
            builder.setDescription("See <a href=\"%s\">Clang-Tidy documentation</a>.".formatted(url));
        }
    }
}

