/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class ClairParser
extends JsonIssueParser {
    private static final long serialVersionUID = 371390072777545322L;

    @Override
    protected void parseJsonObject(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        String image = this.optStringIgnoreCase(jsonReport, "image");
        JSONArray vulnerabilities = this.optJsonArrayIgnoreCase(jsonReport, "vulnerabilities");
        for (Object vulnerability : vulnerabilities) {
            if (!(vulnerability instanceof JSONObject)) continue;
            JSONObject object = (JSONObject)vulnerability;
            report.add(this.convertToIssue(object, image, issueBuilder));
        }
    }

    private Issue convertToIssue(JSONObject jsonIssue, @CheckForNull String image, IssueBuilder issueBuilder) {
        StringBuilder message = new StringBuilder();
        this.appendIfNotEmpty(jsonIssue, message, "featurename", "");
        this.appendIfNotEmpty(jsonIssue, message, "featureversion", ":");
        this.appendIfNotEmpty(jsonIssue, message, "description", "");
        this.appendIfNotEmpty(jsonIssue, message, "fixedby", "Fixed by ");
        this.appendIfNotEmpty(jsonIssue, message, "link", "see ");
        return issueBuilder.setMessage(message.toString()).setCategory(this.optStringIgnoreCase(jsonIssue, "vulnerability")).setSeverity(this.toSeverity(this.optStringIgnoreCase(jsonIssue, "severity"))).setType(this.optStringIgnoreCase(jsonIssue, "namespace")).setFileName(image).buildAndClean();
    }

    private void appendIfNotEmpty(JSONObject issue, StringBuilder message, String key, String head) {
        String text = this.optStringIgnoreCase(issue, key);
        if (text != null && !text.isEmpty()) {
            if (message.length() > 0 && !":".equals(head)) {
                message.append(' ');
            }
            message.append(head).append(text);
        }
    }

    private Severity toSeverity(@CheckForNull String level) {
        if (ClairParser.equalsIgnoreCase(level, "defcon1")) {
            return Severity.ERROR;
        }
        if (ClairParser.equalsIgnoreCase(level, "critical")) {
            return Severity.WARNING_HIGH;
        }
        if (ClairParser.equalsIgnoreCase(level, "high")) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_LOW;
    }

    private JSONArray optJsonArrayIgnoreCase(JSONObject json, String searchKey) {
        JSONArray jsona;
        Object result = this.optIgnoreCase(json, searchKey);
        return result instanceof JSONArray ? (jsona = (JSONArray)result) : new JSONArray();
    }

    @CheckForNull
    private String optStringIgnoreCase(JSONObject json, String searchKey) {
        String s;
        Object result = this.optIgnoreCase(json, searchKey);
        return result instanceof String ? (s = (String)result) : null;
    }

    @CheckForNull
    private Object optIgnoreCase(JSONObject json, String searchKey) {
        Object result = json.opt(searchKey);
        if (result == null) {
            result = this.searchIgnoreCase(json, searchKey);
        }
        return result;
    }

    @CheckForNull
    private Object searchIgnoreCase(JSONObject json, String searchKey) {
        String key;
        Object result = null;
        Iterator iterator = json.keySet().iterator();
        while (iterator.hasNext() && (!ClairParser.equalsIgnoreCase(searchKey, key = (String)iterator.next()) || (result = json.opt(key)) == null)) {
        }
        return result;
    }
}

