/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.util.SecureXmlParserFactory;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.digester3.NodeCreateRule;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CheckStyleParser
extends IssueParser {
    private static final long serialVersionUID = -3187275729854832128L;

    @Override
    public boolean accepts(ReaderFactory readerFactory) {
        return this.isXmlFile(readerFactory);
    }

    @Override
    public Report parseReport(ReaderFactory readerFactory) throws ParsingException {
        Report report;
        block9: {
            SecureDigester digester = new SecureDigester(CheckStyleParser.class);
            String rootXPath = "checkstyle";
            digester.addObjectCreate(rootXPath, CheckStyle.class);
            digester.addSetProperties(rootXPath);
            String fileXPath = "checkstyle/file";
            digester.addObjectCreate(fileXPath, File.class);
            digester.addSetProperties(fileXPath);
            digester.addSetNext(fileXPath, "addFile", File.class.getName());
            String bugXPath = "checkstyle/file/error";
            digester.addObjectCreate(bugXPath, Error.class);
            digester.addSetProperties(bugXPath);
            digester.addSetNext(bugXPath, "addError", Error.class.getName());
            Reader reader = readerFactory.create();
            try {
                CheckStyle checkStyle = (CheckStyle)digester.parse(reader);
                if (checkStyle == null) {
                    throw new ParsingException(readerFactory, "Input stream is not a Checkstyle file.", new Object[0]);
                }
                report = this.convert(checkStyle);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SAXException exception) {
                    throw new ParsingException(exception, readerFactory);
                }
            }
            reader.close();
        }
        return report;
    }

    private Report convert(CheckStyle collection) {
        try (IssueBuilder issueBuilder = new IssueBuilder();){
            Report report = new Report();
            for (File file : collection.getFiles()) {
                if (!this.isValidWarning(file)) continue;
                for (Error error : file.getErrors()) {
                    issueBuilder.guessSeverity(error.getSeverity());
                    String source = error.getSource();
                    issueBuilder.setType(this.getType(source));
                    issueBuilder.setCategory(this.getCategory(source));
                    issueBuilder.setMessage(error.getMessage());
                    issueBuilder.setLineStart(error.getLine());
                    issueBuilder.setFileName(file.getName());
                    issueBuilder.setColumnStart(error.getColumn());
                    report.add(issueBuilder.buildAndClean());
                }
            }
            Report report2 = report;
            return report2;
        }
    }

    @CheckForNull
    private String getCategory(@CheckForNull String source) {
        return StringUtils.capitalize((String)this.getType(StringUtils.substringBeforeLast((String)source, (String)".")));
    }

    @CheckForNull
    private String getType(@CheckForNull String source) {
        if (Strings.CS.contains((CharSequence)source, (CharSequence)".")) {
            return StringUtils.substringAfterLast((String)source, (String)".");
        }
        return source;
    }

    private boolean isValidWarning(File file) {
        return !Strings.CS.endsWith((CharSequence)file.getName(), (CharSequence)"package.html");
    }

    public static class CheckStyle {
        private final List<File> files = new ArrayList<File>();

        public void addFile(File file) {
            this.files.add(file);
        }

        public Collection<File> getFiles() {
            return Collections.unmodifiableCollection(this.files);
        }
    }

    public static class File {
        @CheckForNull
        private String name;
        private final List<Error> errors = new ArrayList<Error>();

        public void addError(Error violation) {
            this.errors.add(violation);
        }

        public Collection<Error> getErrors() {
            return Collections.unmodifiableCollection(this.errors);
        }

        @CheckForNull
        public String getName() {
            return this.name;
        }

        public void setName(@CheckForNull String name) {
            this.name = name;
        }
    }

    public static class Error {
        @CheckForNull
        private String source;
        @CheckForNull
        private String severity;
        @CheckForNull
        private String message;
        private int line;
        private int column;

        public int getColumn() {
            return this.column;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        @CheckForNull
        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        @CheckForNull
        public String getSeverity() {
            return this.severity;
        }

        public void setSeverity(String severity) {
            this.severity = severity;
        }

        @CheckForNull
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }
    }

    public static class TopicRule
    extends NodeCreateRule {
        TopicRule() throws ParserConfigurationException {
            super(1);
        }

        public void end(String namespace, String name) throws TransformerException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
            Element subsection = (Element)this.getDigester().pop();
            String description = this.extractNodeContent(subsection);
            MethodUtils.invokeExactMethod((Object)this.getDigester().peek(), (String)"setValue", (Object)description);
        }

        private String extractNodeContent(Element subsection) throws TransformerException {
            StringWriter content = new StringWriter();
            Transformer transformer = new SecureXmlParserFactory().createTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(subsection), new StreamResult(content));
            String text = content.toString();
            String prefixRemoved = StringUtils.substringAfter((String)text, (String)">");
            String suffixRemoved = StringUtils.substringBeforeLast((String)prefixRemoved, (String)"<");
            String endSourceRemoved = Strings.CS.replace(suffixRemoved, "</source>", "</code></pre>");
            return Strings.CS.replace(endSourceRemoved, "<source>", "<pre><code>");
        }
    }

    public static class Topic {
        @CheckForNull
        private String name;
        @CheckForNull
        private String value;

        public String getName() {
            return StringUtils.defaultString((String)this.name);
        }

        public void setName(@CheckForNull String name) {
            this.name = name;
        }

        public String getValue() {
            return StringUtils.defaultString((String)this.value);
        }

        public void setValue(@CheckForNull String value) {
            this.value = value;
        }
    }

    public static class Rule {
        static final String UNDEFINED_DESCRIPTION = "";
        private static final String DESCRIPTION_SUBSECTION_NAME = "Description";
        @CheckForNull
        private String name;
        @CheckForNull
        private String description;

        public Rule() {
        }

        public Rule(@CheckForNull String name) {
            this.name = name;
            this.description = UNDEFINED_DESCRIPTION;
        }

        public String getName() {
            return StringUtils.defaultString((String)this.name);
        }

        public void setName(@CheckForNull String name) {
            this.name = name;
        }

        public String getDescription() {
            return StringUtils.defaultString((String)this.description);
        }

        @SuppressFBWarnings(value={"IMPROPER_UNICODE"})
        public void setDescription(Topic topic) {
            if (DESCRIPTION_SUBSECTION_NAME.equalsIgnoreCase(topic.getName())) {
                this.description = topic.getValue();
            }
        }
    }
}

