/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.util.IntegerParser;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class CadenceIncisiveParser
extends LookaheadParser {
    private static final long serialVersionUID = -3251791089328958452L;
    private static final String CADENCE_MESSAGE_PATTERN = "((^[a-zA-Z]+): \\*([a-zA-Z]),([a-zA-Z]+): (.*) \\[File:(.*), Line:(.*)\\].)|((^[a-zA-Z]+): \\*([a-zA-Z]),([a-zA-Z]+) \\((.*),([0-9]+)\\|([0-9]+)\\): (.*)$)|((^g?make\\[.*\\]: Entering directory)\\s*(['`]((.*))\\'))|((^[a-zA-Z]+): \\*([a-zA-Z]),([a-zA-Z]+): (.*)$)";

    public CadenceIncisiveParser() {
        super(CADENCE_MESSAGE_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        Severity priority;
        String message;
        String fileName;
        Object category;
        String type;
        String tool;
        int lineNumber = 0;
        if (matcher.group(1) != null) {
            tool = matcher.group(2);
            type = matcher.group(3);
            category = matcher.group(4);
            fileName = matcher.group(6);
            lineNumber = IntegerParser.parseInt(matcher.group(7));
            message = matcher.group(5);
            priority = Severity.WARNING_NORMAL;
        } else {
            if (matcher.group(16) != null) {
                return Optional.empty();
            }
            if (matcher.group(8) != null) {
                tool = matcher.group(9);
                type = matcher.group(10);
                category = matcher.group(11);
                fileName = matcher.group(12);
                lineNumber = IntegerParser.parseInt(matcher.group(13));
                message = matcher.group(15);
                priority = Severity.WARNING_NORMAL;
            } else if (matcher.group(21) != null) {
                tool = matcher.group(22);
                type = matcher.group(23);
                category = matcher.group(24);
                fileName = "";
                message = matcher.group(25);
                priority = Severity.WARNING_LOW;
            } else {
                return Optional.empty();
            }
        }
        if (CadenceIncisiveParser.equalsIgnoreCase(type, "E")) {
            priority = Severity.WARNING_HIGH;
            category = "Error (" + tool + "): " + (String)category;
        } else {
            category = "Warning (" + tool + "): " + (String)category;
        }
        if (fileName == null) {
            return Optional.empty();
        }
        return builder.setFileName(fileName).setLineStart(lineNumber).setCategory((String)category).setMessage(message).setSeverity(priority).buildOptional();
    }
}

