/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.FormatMethod;
import edu.hm.hafner.analysis.ReaderFactory;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ParsingException
extends RuntimeException {
    private static final long serialVersionUID = -9016364685084958944L;

    public ParsingException(Throwable cause) {
        super(ParsingException.createMessage(cause, "Exception occurred during parsing"), cause);
    }

    public ParsingException(Throwable cause, ReaderFactory reader) {
        super(ParsingException.createMessage(cause, "%s: Exception occurred during parsing".formatted(reader.getFileName())), cause);
    }

    @FormatMethod
    public ParsingException(Throwable cause, String messageFormat, Object ... args) {
        super(ParsingException.createMessage(cause, messageFormat.formatted(args)), cause);
    }

    @FormatMethod
    public ParsingException(String messageFormat, Object ... args) {
        super(messageFormat.formatted(args));
    }

    @FormatMethod
    public ParsingException(ReaderFactory reader, String messageFormat, Object ... args) {
        super("%s: %s".formatted(reader.getFileName(), messageFormat.formatted(args)));
    }

    private static String createMessage(Throwable cause, String message) {
        return "%s%n%s%n%s".formatted(message, ExceptionUtils.getMessage((Throwable)cause), ExceptionUtils.getStackTrace((Throwable)cause));
    }
}

