/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.PackageDetectorFactory;
import edu.hm.hafner.util.PackageDetectorRunner;
import edu.hm.hafner.util.VisibleForTesting;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PackageNameResolver {
    private final PackageDetectorRunner runner;

    public PackageNameResolver() {
        this(PackageDetectorFactory.createPackageDetectors());
    }

    @VisibleForTesting
    PackageNameResolver(PackageDetectorRunner runner) {
        this.runner = runner;
    }

    public void run(Report report, Charset charset) {
        Set filesWithoutPackageName = report.stream().filter(issue -> !issue.hasPackageName()).map(Issue::getAbsolutePath).collect(Collectors.toSet());
        if (filesWithoutPackageName.isEmpty()) {
            report.logInfo("-> all affected files already have a valid package name", new Object[0]);
            return;
        }
        HashMap packagesOfFiles = new HashMap();
        filesWithoutPackageName.stream().map(f -> this.extractPackageName((String)f, charset)).flatMap(Optional::stream).forEach(e -> packagesOfFiles.put((String)e.getKey(), (String)e.getValue()));
        try (IssueBuilder builder = new IssueBuilder();){
            report.stream().forEach(issue -> {
                if (!issue.hasPackageName()) {
                    issue.setPackageName(builder.internPackageName((String)packagesOfFiles.get(issue.getAbsolutePath())));
                }
            });
        }
        report.logInfo("-> resolved package names of %d affected files", filesWithoutPackageName.size());
    }

    private Optional<Map.Entry<String, String>> extractPackageName(String fileName, Charset charset) {
        return this.runner.detectPackageName(fileName, charset).map(r -> Map.entry(fileName, r));
    }
}

