/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.xpath.InternalApiBridge;
import net.sourceforge.pmd.lang.rule.xpath.XPathRule;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ResourceLoader {
    public static final int TIMEOUT;
    private final ClassLoader classLoader;

    public ResourceLoader() {
        this(ResourceLoader.class.getClassLoader());
    }

    public ResourceLoader(ClassLoader cl) {
        this.classLoader = Objects.requireNonNull(cl);
    }

    public @NonNull InputStream loadResourceAsStream(String name) throws IOException {
        File file = new File(name);
        if (file.exists()) {
            try {
                return Files.newInputStream(file.toPath(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IOException("File was checked to exist", e);
            }
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(name).openConnection();
            connection.setConnectTimeout(TIMEOUT);
            connection.setReadTimeout(TIMEOUT);
            InputStream is = connection.getInputStream();
            if (is != null) {
                return is;
            }
        }
        catch (Exception e) {
            return this.loadClassPathResourceAsStreamOrThrow(name);
        }
        throw new IOException("Can't find resource " + name + ". Make sure the resource is a valid file or URL or is on the classpath");
    }

    public @Nullable InputStream loadClassPathResourceAsStream(String name) throws IOException {
        URL resource = this.classLoader.getResource(name);
        if (resource == null) {
            return null;
        }
        URLConnection connection = resource.openConnection();
        connection.setUseCaches(false);
        return connection.getInputStream();
    }

    public @NonNull InputStream loadClassPathResourceAsStreamOrThrow(String name) throws IOException {
        InputStream is = null;
        try {
            is = this.loadClassPathResourceAsStream(name);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (is == null) {
            throw new FileNotFoundException("Can't find resource " + name + ". Make sure the resource is on the classpath");
        }
        return is;
    }

    public Rule loadRuleFromClassPath(String clazz) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (XPathRule.class.getName().equals(clazz)) {
            return InternalApiBridge.newXPathRule();
        }
        return (Rule)this.classLoader.loadClass(clazz).newInstance();
    }

    static {
        int timeoutProperty = 5000;
        try {
            timeoutProperty = Integer.parseInt(System.getProperty("net.sourceforge.pmd.http.timeout", "5000"));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        TIMEOUT = timeoutProperty;
    }
}

