/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class StringUtil {
    private static final Pattern XML_10_INVALID_CHARS = Pattern.compile("[[\\x00-\\x1F]&&[^\\x09\\x0A\\x0D]]");

    private StringUtil() {
    }

    public static String inSingleQuotes(String s) {
        if (s == null) {
            s = "";
        }
        return "'" + s + "'";
    }

    public static @NonNull String inDoubleQuotes(String expected) {
        return "\"" + expected + "\"";
    }

    public static int lineNumberAt(CharSequence charSeq, int offsetInclusive) {
        int len = charSeq.length();
        if (offsetInclusive > len || offsetInclusive < 0) {
            return -1;
        }
        int l = 1;
        for (int curOffset = 0; curOffset < offsetInclusive; ++curOffset) {
            if (curOffset >= len) {
                return -1;
            }
            char c = charSeq.charAt(curOffset);
            if (c == '\n') {
                ++l;
                continue;
            }
            if (c != '\r') continue;
            if (curOffset + 1 < len && charSeq.charAt(curOffset + 1) == '\n') {
                if (curOffset == offsetInclusive - 1) {
                    return l;
                }
                ++curOffset;
            }
            ++l;
        }
        return l;
    }

    public static int columnNumberAt(CharSequence charSeq, int offsetInclusive) {
        if (offsetInclusive == charSeq.length()) {
            return charSeq.length() == 0 ? 1 : 1 + StringUtil.columnNumberAt(charSeq, offsetInclusive - 1);
        }
        if (offsetInclusive > charSeq.length() || offsetInclusive < 0) {
            return -1;
        }
        int col = 0;
        char next = '\u0000';
        for (int i = offsetInclusive; i >= 0; --i) {
            char c = charSeq.charAt(i);
            if (offsetInclusive != i && (c == '\n' || c == '\r' && next != '\n')) {
                return col;
            }
            ++col;
            next = c;
        }
        return col;
    }

    public static StringBuilder append(StringBuilder sb, CharSequence charSeq) {
        if (charSeq instanceof Chars) {
            ((Chars)charSeq).appendChars(sb);
            return sb;
        }
        return sb.append(charSeq);
    }

    public static String substringAfterLast(String str, int c) {
        int i = str.lastIndexOf(c);
        return i < 0 ? str : str.substring(i + 1);
    }

    public static String percentageString(double val, int numDecimals) {
        if (val < 0.0 || val > 1.0) {
            throw new IllegalArgumentException("Expected a number between 0 and 1");
        }
        return String.format(Locale.ROOT, "%." + numDecimals + "f%%", 100.0 * val);
    }

    public static String withoutPrefixes(String text, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!text.startsWith(prefix)) continue;
            return text.substring(prefix.length());
        }
        return text;
    }

    public static String removedInvalidXml10Characters(String text) {
        Matcher matcher = XML_10_INVALID_CHARS.matcher(text);
        return matcher.replaceAll("");
    }

    public static String escapeWhitespace(Object o) {
        if (o == null) {
            return null;
        }
        String s = String.valueOf(o);
        s = s.replace("\n", "\\n");
        s = s.replace("\r", "\\r");
        s = s.replace("\t", "\\t");
        return s;
    }

    private static int maxCommonLeadingWhitespaceForAll(List<? extends CharSequence> lines) {
        int maxCommonWs = Integer.MAX_VALUE;
        for (int i = 0; i < lines.size(); ++i) {
            CharSequence line = lines.get(i);
            if (StringUtils.isBlank((CharSequence)line) && i != lines.size() - 1) continue;
            maxCommonWs = Math.min(maxCommonWs, StringUtil.countLeadingWhitespace(line));
        }
        if (maxCommonWs == Integer.MAX_VALUE) {
            maxCommonWs = 0;
        }
        return maxCommonWs;
    }

    public static List<Chars> linesWithTrimIndent(Chars source) {
        List<Chars> result = source.lineStream().collect(CollectionUtil.toMutableList());
        StringUtil.trimIndentInPlace(result);
        return result;
    }

    public static void trimIndentInPlace(List<Chars> lines) {
        int trimDepth = StringUtil.maxCommonLeadingWhitespaceForAll(lines);
        lines.replaceAll(chars -> chars.length() >= trimDepth ? chars.subSequence(trimDepth).trimEnd() : chars.trimEnd());
    }

    public static StringBuilder trimIndent(Chars string) {
        List<Chars> lines = string.lineStream().collect(CollectionUtil.toMutableList());
        StringUtil.trimIndentInPlace(lines);
        return CollectionUtil.joinCharsIntoStringBuilder(lines, "\n");
    }

    private static int countLeadingWhitespace(CharSequence s) {
        int count;
        for (count = 0; count < s.length() && Character.isWhitespace(s.charAt(count)); ++count) {
        }
        return count;
    }

    public static boolean isSame(String s1, String s2, boolean trim, boolean ignoreCase, boolean standardizeWhitespace) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (trim) {
            s1 = s1.trim();
            s2 = s2.trim();
        }
        if (standardizeWhitespace) {
            s1 = s1.replaceAll("\\s+", " ");
            s2 = s2.replaceAll("\\s+", " ");
        }
        return ignoreCase ? s1.equalsIgnoreCase(s2) : s1.equals(s2);
    }

    public static String asString(Object[] items, String separator) {
        if (items == null || items.length == 0) {
            return "";
        }
        if (items.length == 1) {
            return items[0].toString();
        }
        StringBuilder sb = new StringBuilder(items[0].toString());
        for (int i = 1; i < items.length; ++i) {
            sb.append(separator).append(items[i]);
        }
        return sb.toString();
    }

    public static String removeSurrounding(String string, char delimiter) {
        if (string.length() >= 2 && string.charAt(0) == delimiter && string.charAt(string.length() - 1) == delimiter) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String removeDoubleQuotes(String string) {
        return StringUtil.removeSurrounding(string, '\"');
    }

    public static String elide(String string, int maxOutputLength, String ellipsis) {
        AssertionUtil.requireNonNegative("maxOutputLength", maxOutputLength);
        if (ellipsis.length() > maxOutputLength) {
            throw new IllegalArgumentException("Ellipsis too long '" + ellipsis + "', maxOutputLength=" + maxOutputLength);
        }
        if (string.length() <= maxOutputLength) {
            return string;
        }
        String truncated = string.substring(0, maxOutputLength - ellipsis.length());
        return truncated + ellipsis;
    }

    public static String escapeJava(String str) {
        StringBuilder retval = new StringBuilder();
        block11: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u").append(s.substring(s.length() - 4));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }

    public static String quoteMessageFormat(String str) {
        return str.replaceAll("'", "''");
    }

    public static String nullToEmpty(String value) {
        return value == null ? "" : value;
    }

    public static enum CaseConvention {
        SCREAMING_SNAKE_CASE{

            @Override
            List<String> toWords(String name) {
                return CollectionUtil.map(name.split("_"), s -> s.toLowerCase(Locale.ROOT));
            }

            @Override
            String joinWords(List<String> words) {
                return words.stream().map(s -> s.toUpperCase(Locale.ROOT)).collect(Collectors.joining("_"));
            }
        }
        ,
        CAMEL_CASE{

            @Override
            List<String> toWords(String name) {
                return PASCAL_CASE.toWords(name);
            }

            @Override
            String joinWords(List<String> words) {
                if (words.isEmpty()) {
                    return "";
                }
                return words.get(0).toLowerCase(Locale.ROOT) + PASCAL_CASE.joinWords(words.subList(1, words.size()));
            }
        }
        ,
        PASCAL_CASE{

            @Override
            List<String> toWords(String name) {
                return CollectionUtil.map(name.split("(?<![A-Z])(?=[A-Z])"), s -> s.toLowerCase(Locale.ROOT));
            }

            @Override
            String joinWords(List<String> words) {
                return words.stream().map(StringUtils::capitalize).collect(Collectors.joining());
            }
        }
        ,
        SPACE_SEPARATED{

            @Override
            List<String> toWords(String name) {
                return CollectionUtil.map(name.split("\\s++"), s -> s.toLowerCase(Locale.ROOT));
            }

            @Override
            String joinWords(List<String> words) {
                return String.join((CharSequence)" ", words);
            }
        };


        abstract List<String> toWords(String var1);

        abstract String joinWords(List<String> var1);

        public String convertTo(CaseConvention to, String name) {
            return to.joinWords(this.toWords(name));
        }
    }
}

