/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;

@FunctionalInterface
public interface ViolationDecorator {
    public void decorate(Node var1, Map<String, String> var2);

    public static Map<String, String> apply(ViolationDecorator decorator, Node violationNode) {
        HashMap<String, String> additionalInfo = new HashMap<String, String>();
        decorator.decorate(violationNode, additionalInfo);
        if (!additionalInfo.isEmpty()) {
            return Collections.unmodifiableMap(additionalInfo);
        }
        return Collections.emptyMap();
    }

    public static ViolationDecorator chain(List<? extends ViolationDecorator> list) {
        return (node, map) -> {
            for (ViolationDecorator decorator : list) {
                decorator.decorate(node, map);
            }
        };
    }

    public static ViolationDecorator noop() {
        return (node, map) -> {};
    }
}

