/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.util.Collections;
import java.util.Map;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.reporting.Reportable;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.util.AssertionUtil;

class ParametricRuleViolation
implements RuleViolation {
    protected final Rule rule;
    protected final String description;
    private final FileLocation location;
    private final Map<String, String> additionalInfo;

    ParametricRuleViolation(Rule theRule, Reportable node, String message) {
        this(theRule, node.getReportLocation(), message, Collections.emptyMap());
    }

    ParametricRuleViolation(Rule theRule, FileLocation location, String message, Map<String, String> additionalInfo) {
        this.rule = AssertionUtil.requireParamNotNull("rule", theRule);
        this.description = AssertionUtil.requireParamNotNull("message", message);
        this.location = location;
        this.additionalInfo = !additionalInfo.isEmpty() ? Collections.unmodifiableMap(additionalInfo) : Collections.emptyMap();
    }

    @Override
    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public FileLocation getLocation() {
        return this.location;
    }

    public String toString() {
        return this.getLocation().startPosToStringWithFile() + ':' + this.getRule() + ':' + this.getDescription();
    }
}

