/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sourceforge.pmd.util.internal.ResourceLoader;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RuleSetReferenceId {
    private final @Nullable String ruleSetReference;
    private final @Nullable String ruleName;
    private final @NonNull String originalRef;

    private RuleSetReferenceId(String ruleSetReference, String ruleName) {
        this.ruleSetReference = ruleSetReference;
        this.ruleName = ruleName;
        this.originalRef = ruleSetReference;
    }

    public RuleSetReferenceId(String reference) {
        this(reference, (RuleSetReferenceId)null);
    }

    public RuleSetReferenceId(String id, RuleSetReferenceId absoluteRuleSetReferenceId) {
        String tempRuleSetReference;
        this.originalRef = StringUtils.trim((String)id);
        if (this.originalRef != null && this.originalRef.indexOf(44) >= 0) {
            throw new IllegalArgumentException("A single RuleSetReferenceId cannot contain ',' (comma) characters: " + id);
        }
        if (absoluteRuleSetReferenceId != null && !absoluteRuleSetReferenceId.isAbsolute()) {
            throw new IllegalArgumentException("Cannot pair with relative <" + absoluteRuleSetReferenceId + ">.");
        }
        if (RuleSetReferenceId.isFullRuleSetName(this.originalRef) && absoluteRuleSetReferenceId != null) {
            throw new IllegalArgumentException("Cannot pair absolute <" + this.originalRef + "> with absolute <" + absoluteRuleSetReferenceId + ">.");
        }
        if (this.originalRef == null && absoluteRuleSetReferenceId == null) {
            throw new IllegalArgumentException("Either ID or absoluteRuleSetReferenceId is required");
        }
        String tempRuleName = this.getRuleName(this.originalRef);
        String string = tempRuleSetReference = tempRuleName == null ? null : this.originalRef.substring(0, this.originalRef.length() - tempRuleName.length() - 1);
        if (RuleSetReferenceId.isFullRuleSetName(tempRuleSetReference) && absoluteRuleSetReferenceId != null) {
            throw new IllegalArgumentException("Cannot pair absolute <" + this.originalRef + "> with absolute <" + absoluteRuleSetReferenceId + ">.");
        }
        if (absoluteRuleSetReferenceId != null && absoluteRuleSetReferenceId.isAbsolute()) {
            this.ruleSetReference = absoluteRuleSetReferenceId.getRuleSetFileName();
            this.ruleName = this.originalRef;
        } else if (RuleSetReferenceId.isFullRuleSetName(this.originalRef)) {
            this.ruleSetReference = this.originalRef;
            this.ruleName = null;
        } else if (RuleSetReferenceId.isFullRuleSetName(tempRuleSetReference)) {
            this.ruleSetReference = tempRuleSetReference;
            this.ruleName = tempRuleName;
        } else if (this.originalRef.indexOf(47) == -1 && this.originalRef.indexOf(92) == -1) {
            this.ruleSetReference = null;
            this.ruleName = this.originalRef;
        } else {
            this.ruleSetReference = this.originalRef;
            this.ruleName = null;
        }
    }

    public @Nullable RuleSetReferenceId getParentRulesetIfThisIsARule() {
        if (this.ruleName == null) {
            return null;
        }
        return new RuleSetReferenceId(this.ruleSetReference, (String)null);
    }

    private String getRuleName(String rulesetName) {
        int separatorIndex;
        String result = null;
        if (rulesetName != null && (separatorIndex = Math.max(rulesetName.lastIndexOf(47), rulesetName.lastIndexOf(92))) >= 0 && separatorIndex != rulesetName.length() - 1) {
            result = rulesetName.substring(separatorIndex + 1);
        }
        return result;
    }

    private static boolean isFullRuleSetName(String name) {
        return name != null && name.toLowerCase(Locale.ROOT).endsWith(".xml");
    }

    public static List<RuleSetReferenceId> parse(String referenceString) {
        ArrayList<RuleSetReferenceId> references = new ArrayList<RuleSetReferenceId>();
        if (referenceString != null && referenceString.trim().length() > 0) {
            if (referenceString.indexOf(44) == -1) {
                references.add(new RuleSetReferenceId(referenceString));
            } else {
                for (String name : referenceString.split(",")) {
                    references.add(new RuleSetReferenceId(name.trim()));
                }
            }
        }
        return references;
    }

    public boolean isAbsolute() {
        return this.ruleSetReference != null;
    }

    public boolean isAllRules() {
        return this.ruleName == null;
    }

    public String getRuleSetFileName() {
        return this.ruleSetReference;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public InputStream getInputStream(ResourceLoader rl) throws IOException {
        if (!this.isAbsolute()) {
            throw new IllegalArgumentException("Cannot resolve rule/ruleset reference '" + this + "' - reference is not absolute");
        }
        try {
            return rl.loadResourceAsStream(this.ruleSetReference);
        }
        catch (FileNotFoundException ignored) {
            throw this.notFoundException();
        }
    }

    private FileNotFoundException notFoundException() {
        return new FileNotFoundException("Cannot resolve rule/ruleset reference '" + this.originalRef + "'.  Make sure the resource is a valid file or URL and is on the CLASSPATH. Use --debug (or a fine log level) to see the current classpath.");
    }

    public String toNormalizedReference() {
        if (this.isAbsolute()) {
            if (this.isAllRules()) {
                return this.ruleSetReference;
            }
            return this.ruleSetReference + '/' + this.ruleName;
        }
        return this.ruleName;
    }

    public String toString() {
        return this.toNormalizedReference();
    }
}

