/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.sourceforge.pmd.lang.document.TextRegion;
import net.sourceforge.pmd.util.IteratorUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Chars
implements CharSequence {
    public static final Chars EMPTY = new Chars("", 0, 0);
    private static final int NOT_TRIED = -2;
    private static final int NOT_FOUND = -1;
    private final String str;
    private final int start;
    private final int len;

    private Chars(String str, int start, int len) {
        Chars.validateRangeWithAssert(start, len, str.length());
        this.str = str;
        this.start = start;
        this.len = len;
    }

    private int idx(int off) {
        return this.start + off;
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    public static Chars wrap(CharSequence chars) {
        if (chars instanceof Chars) {
            return (Chars)chars;
        }
        if (chars.length() == 0) {
            return EMPTY;
        }
        return new Chars(chars.toString(), 0, chars.length());
    }

    public void writeFully(@NonNull Writer writer) throws IOException {
        this.write(writer, 0, this.length());
    }

    public void write(@NonNull Writer writer, int start, int count) throws IOException {
        writer.write(this.str, this.idx(start), count);
    }

    public void getChars(int srcBegin, char @NonNull [] cbuf, int dstBegin, int count) {
        Chars.validateRange(srcBegin, count, this.length());
        int start = this.idx(srcBegin);
        this.str.getChars(start, start + count, cbuf, dstBegin);
    }

    public void appendChars(StringBuilder sb, int start, int end) {
        if (end == 0) {
            return;
        }
        sb.append(this.str, this.idx(start), this.idx(end));
    }

    public void appendChars(StringBuilder sb) {
        sb.append(this.str, this.start, this.start + this.len);
    }

    public ByteBuffer getBytes(Charset charset) {
        return charset.encode(CharBuffer.wrap(this.str, this.start, this.start + this.len));
    }

    public int indexOf(String searched, int fromIndex) {
        int max = this.start + this.len - searched.length();
        if (fromIndex < 0 || max < this.start + fromIndex) {
            return -1;
        }
        if (searched.isEmpty()) {
            return 0;
        }
        char fst = searched.charAt(0);
        int strpos = this.str.indexOf(fst, this.idx(fromIndex));
        while (strpos != -1 && strpos <= max) {
            if (this.str.startsWith(searched, strpos)) {
                return strpos - this.start;
            }
            strpos = this.str.indexOf(fst, strpos + 1);
        }
        return -1;
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        return this.indexOf(ch, fromIndex, Integer.MAX_VALUE);
    }

    public int indexOf(int ch, int fromIndex, int toIndex) {
        assert (fromIndex <= toIndex) : "Malformed range " + fromIndex + " > " + toIndex;
        fromIndex = Math.max(fromIndex, 0);
        toIndex = Math.min(toIndex, this.len);
        if (fromIndex >= this.len || toIndex <= 0) {
            return -1;
        }
        if (toIndex == this.len && this.start + this.len == this.str.length()) {
            int i = this.str.indexOf(ch, this.start + fromIndex);
            return i == -1 ? -1 : i - this.start;
        }
        int max = this.start + toIndex;
        for (int i = this.start + fromIndex; i < max; ++i) {
            char c = this.str.charAt(i);
            if (c != ch) continue;
            return i - this.start;
        }
        return -1;
    }

    public int lastIndexOf(int ch, int fromIndex) {
        if (fromIndex < 0 || fromIndex >= this.len) {
            return -1;
        }
        for (int i = this.start + fromIndex; i >= this.start; --i) {
            char c = this.str.charAt(i);
            if (c != ch) continue;
            return i - this.start;
        }
        return -1;
    }

    public boolean startsWith(String prefix, int fromIndex) {
        if (fromIndex < 0 || fromIndex + prefix.length() > this.len) {
            return false;
        }
        return this.str.startsWith(prefix, this.idx(fromIndex));
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(char prefix, int fromIndex) {
        if (fromIndex < 0 || fromIndex + 1 > this.len) {
            return false;
        }
        return this.str.charAt(this.idx(fromIndex)) == prefix;
    }

    public boolean endsWith(String suffix) {
        return this.startsWith(suffix, this.length() - suffix.length());
    }

    public Chars trimStart() {
        int i;
        int maxIdx = this.start + this.len;
        for (i = this.start; i < maxIdx && this.str.charAt(i) <= ' '; ++i) {
        }
        return this.slice(i -= this.start, this.len - i);
    }

    public Chars trimEnd() {
        int i;
        for (i = this.start + this.len; i > this.start && this.str.charAt(i - 1) <= ' '; --i) {
        }
        return this.slice(0, i - this.start);
    }

    public Chars trim() {
        return this.trimStart().trimEnd();
    }

    public Chars trimBlankLines() {
        int offsetOfFirstNonBlankChar = this.length();
        for (int i = 0; i < this.length(); ++i) {
            if (Character.isWhitespace(this.charAt(i))) continue;
            offsetOfFirstNonBlankChar = i;
            break;
        }
        int offsetOfLastNonBlankChar = 0;
        for (int i = this.length() - 1; i > offsetOfFirstNonBlankChar; --i) {
            if (Character.isWhitespace(this.charAt(i))) continue;
            offsetOfLastNonBlankChar = i;
            break;
        }
        int cutFromInclusive = this.lastIndexOf(10, offsetOfFirstNonBlankChar);
        ++cutFromInclusive;
        int cutUntilExclusive = this.indexOf(10, offsetOfLastNonBlankChar);
        if (cutUntilExclusive == -1) {
            cutUntilExclusive = this.length();
        }
        return this.subSequence(cutFromInclusive, cutUntilExclusive);
    }

    public Chars removeSuffix(String charSeq) {
        int trimmedLen = this.length() - charSeq.length();
        if (this.startsWith(charSeq, trimmedLen)) {
            return this.slice(0, trimmedLen);
        }
        return this;
    }

    public Chars removePrefix(String charSeq) {
        if (this.startsWith(charSeq)) {
            return this.subSequence(charSeq.length(), this.length());
        }
        return this;
    }

    public boolean contentEquals(CharSequence cs, boolean ignoreCase) {
        if (cs instanceof Chars) {
            Chars chars2 = (Chars)cs;
            return this.len == chars2.len && this.str.regionMatches(ignoreCase, this.start, chars2.str, chars2.start, this.len);
        }
        return this.length() == cs.length() && this.str.regionMatches(ignoreCase, this.start, cs.toString(), 0, this.len);
    }

    public boolean contentEquals(CharSequence cs) {
        return this.contentEquals(cs, false);
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.len) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.str.charAt(this.idx(index));
    }

    @Override
    public Chars subSequence(int start, int end) {
        return this.slice(start, end - start);
    }

    public Chars subSequence(int start) {
        return this.slice(start, this.len - start);
    }

    public Chars slice(TextRegion region) {
        return this.slice(region.getStartOffset(), region.getLength());
    }

    public Chars slice(int off, int len) {
        Chars.validateRange(off, len, this.len);
        if (len == 0) {
            return EMPTY;
        }
        if (off == 0 && len == this.len) {
            return this;
        }
        return new Chars(this.str, this.idx(off), len);
    }

    public String substring(int start, int end) {
        Chars.validateRange(start, end - start, this.len);
        return this.str.substring(this.idx(start), this.idx(end));
    }

    public String substring(int start) {
        return this.substring(start, this.len);
    }

    private static void validateRangeWithAssert(int off, int len, int bound) {
        assert (len >= 0 && off >= 0 && off + len <= bound) : Chars.invalidRange(off, len, bound);
    }

    private static void validateRange(int off, int len, int bound) {
        if (len < 0 || off < 0 || off + len > bound) {
            throw new IndexOutOfBoundsException(Chars.invalidRange(off, len, bound));
        }
    }

    private static String invalidRange(int off, int len, int bound) {
        return "Invalid range [" + off + ", " + (off + len) + "[ (length " + len + ") in string of length " + bound;
    }

    @Override
    public @NonNull String toString() {
        return this.str.substring(this.start, this.start + this.len);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Chars && this.contentEquals((Chars)o);
    }

    public int hashCode() {
        if (this.isFullString()) {
            return this.str.hashCode();
        }
        int h = 0;
        int end = this.start + this.len;
        for (int i = this.start; i < end; ++i) {
            h = h * 31 + this.str.charAt(i);
        }
        return h;
    }

    boolean isFullString() {
        return this.start == 0 && this.len == this.str.length();
    }

    public Iterable<Chars> lines() {
        return () -> new Iterator<Chars>(){
            final int max;
            int pos;
            int nextCr;
            int nextLf;
            {
                this.max = Chars.this.len;
                this.pos = 0;
                this.nextCr = -2;
                this.nextLf = -2;
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.max;
            }

            @Override
            public Chars next() {
                int curPos = this.pos;
                if (this.nextCr == -2) {
                    this.nextCr = Chars.this.indexOf(13, curPos);
                }
                if (this.nextLf == -2) {
                    this.nextLf = Chars.this.indexOf(10, curPos);
                }
                int cr = this.nextCr;
                int lf = this.nextLf;
                if (cr != -1 && lf != -1) {
                    int min = Math.min(cr, lf);
                    if (lf == cr + 1) {
                        this.pos = lf + 1;
                        this.nextCr = -2;
                        this.nextLf = -2;
                    } else {
                        this.pos = min + 1;
                        this.resetLookahead(cr, min);
                    }
                    return Chars.this.subSequence(curPos, min);
                }
                if (cr == -1 && lf == -1) {
                    this.pos = this.max;
                    return Chars.this.subSequence(curPos, this.max);
                }
                int idx = Math.max(cr, lf);
                this.resetLookahead(cr, idx);
                this.pos = idx + 1;
                return Chars.this.subSequence(curPos, idx);
            }

            private void resetLookahead(int cr, int idx) {
                if (idx == cr) {
                    this.nextCr = -2;
                } else {
                    this.nextLf = -2;
                }
            }
        };
    }

    public Stream<Chars> lineStream() {
        return StreamSupport.stream(this.lines().spliterator(), false);
    }

    public StringBuilder toStringBuilder() {
        StringBuilder sb = new StringBuilder(this.length());
        this.appendChars(sb);
        return sb;
    }

    public Iterable<Chars> splits(final Pattern regex) {
        return () -> new IteratorUtil.AbstractIterator<Chars>(){
            final Matcher matcher;
            int lastPos;
            {
                this.matcher = regex.matcher(Chars.this);
                this.lastPos = 0;
            }

            private boolean shouldRetry() {
                if (this.matcher.find()) {
                    if (this.matcher.start() == 0 && this.matcher.end() == 0 && this.lastPos != Chars.this.len) {
                        return true;
                    }
                    this.setNext(Chars.this.subSequence(this.lastPos, this.matcher.start()));
                    this.lastPos = this.matcher.end();
                } else if (this.lastPos != Chars.this.len) {
                    this.setNext(Chars.this.subSequence(this.lastPos, Chars.this.len));
                } else {
                    this.done();
                }
                return false;
            }

            @Override
            protected void computeNext() {
                if (this.matcher.hitEnd()) {
                    this.done();
                } else if (this.shouldRetry()) {
                    this.shouldRetry();
                }
            }
        };
    }

    public Reader newReader() {
        return new CharsReader(this);
    }

    private static final class CharsReader
    extends Reader {
        private Chars chars;
        private int pos;
        private final int max;
        private int mark = -1;

        private CharsReader(Chars chars) {
            this.chars = chars;
            this.pos = chars.start;
            this.max = chars.start + chars.len;
        }

        @Override
        public int read(char @NonNull [] cbuf, int off, int len) throws IOException {
            if (len < 0 || off < 0 || off + len > cbuf.length) {
                throw new IndexOutOfBoundsException();
            }
            this.ensureOpen();
            if (this.pos >= this.max) {
                return -1;
            }
            int toRead = Integer.min(this.max - this.pos, len);
            this.chars.str.getChars(this.pos, this.pos + toRead, cbuf, off);
            this.pos += toRead;
            return toRead;
        }

        @Override
        public int read() throws IOException {
            this.ensureOpen();
            return this.pos >= this.max ? -1 : (int)this.chars.str.charAt(this.pos++);
        }

        @Override
        public long skip(long n) throws IOException {
            this.ensureOpen();
            int oldPos = this.pos;
            this.pos = Math.min(this.max, this.pos + (int)n);
            return this.pos - oldPos;
        }

        private void ensureOpen() throws IOException {
            if (this.chars == null) {
                throw new IOException("Closed");
            }
        }

        @Override
        public void close() {
            this.chars = null;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.pos;
        }

        @Override
        public void reset() throws IOException {
            this.ensureOpen();
            if (this.mark == -1) {
                throw new IOException("Reader was not marked");
            }
            this.pos = this.mark;
        }

        @Override
        public boolean markSupported() {
            return true;
        }
    }
}

